/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.openxmlformats.styles.table;

import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableValueProvider<Value> {
    public Value getValue(CTTbl table, XWPFStylesDocument document) {
        Value value = null;
        CTTblPr tblPr = table.getTblPr();
        if (tblPr != null) {
            value = this.getValue(tblPr, document);
            if (value != null) {
                return value;
            }
            value = this.getValueFromStyle(tblPr.getTblStyle(), document);
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    private Value getValueFromStyle(CTString styleId, XWPFStylesDocument document) {
        CTStyle style = document.getStyle(styleId);
        return this.getValueFromStyle(style, document);
    }

    private Value getValueFromStyle(CTStyle style, XWPFStylesDocument document) {
        if (style != null) {
            Value value = this.getValue(style.getTblPr(), document);
            if (value != null) {
                return value;
            }
            return this.getValueFromStyle(style.getBasedOn(), document);
        }
        return null;
    }

    public abstract Value getValue(CTTblPr var1, XWPFStylesDocument var2);

    public abstract Value getValue(CTTblPrBase var1, XWPFStylesDocument var2);
}

