/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.converter.core.IImageExtractor;
import org.odftoolkit.odfdom.converter.core.utils.StringUtils;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ElementVisitorConverter
extends DefaultElementVisitor {
    private static final Logger LOGGER = Logger.getLogger(ElementVisitorConverter.class.getName());
    protected final OdfDocument odfDocument;
    protected final OutputStream out;
    protected final Writer writer;
    private final IImageExtractor extractor;

    public ElementVisitorConverter(OdfDocument odfDocument, OutputStream out, Writer writer) {
        this(odfDocument, null, out, writer);
    }

    public ElementVisitorConverter(OdfDocument odfDocument, IImageExtractor extractor, OutputStream out, Writer writer) {
        this.odfDocument = odfDocument;
        this.out = out;
        this.writer = writer;
        this.extractor = extractor;
    }

    public void visit(OdfElement ele) {
        int nodeType = -1;
        block4: for (Node node = ele.getFirstChild(); node != null; node = node.getNextSibling()) {
            nodeType = node.getNodeType();
            switch (nodeType) {
                case 1: {
                    OdfElement element = (OdfElement)node;
                    element.accept((ElementVisitor)this);
                    continue block4;
                }
                case 3: {
                    this.processTextNode((Text)node);
                }
            }
        }
    }

    protected abstract void processTextNode(Text var1);

    public final void visit(DrawImageElement ele) {
        String href = ele.getXlinkHrefAttribute();
        if (StringUtils.isNotEmpty(href)) {
            byte[] imageStream;
            IImageExtractor extractor = this.getExtractor();
            boolean needImageStream = this.isNeedImageStream() || extractor != null;
            byte[] byArray = imageStream = needImageStream ? this.odfDocument.getPackage().getBytes(href) : null;
            if (extractor != null && imageStream != null) {
                try {
                    extractor.extract(href, imageStream);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Error while extracting the image " + href, e);
                }
            }
            this.visitImage(ele, href, imageStream);
        }
    }

    protected void visitImage(DrawImageElement ele, String href, byte[] imageStream) {
    }

    protected boolean isNeedImageStream() {
        return false;
    }

    public IImageExtractor getExtractor() {
        return this.extractor;
    }

    public void save() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

