/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal;

import com.lowagie.text.Image;
import fr.opensagres.xdocreport.itext.extension.PageOrientation;
import fr.opensagres.xdocreport.utils.BorderType;
import fr.opensagres.xdocreport.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odftoolkit.odfdom.converter.core.AbstractStyleEngine;
import org.odftoolkit.odfdom.converter.core.utils.ODFUtils;
import org.odftoolkit.odfdom.converter.pdf.PdfOptions;
import org.odftoolkit.odfdom.converter.pdf.internal.ColorRegistry;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableImage;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleBorder;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleBreak;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleColumnProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleGraphicProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleHeaderFooterProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleLineHeight;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleListProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleNumFormat;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StylePageLayoutProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleSectionProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTabStopProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableCellProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableRowProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakBeforeAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoFontWeightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoKeepTogetherAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontStyleComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontWeightAsianAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleFontWeightComplexAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintOrientationAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextLineThroughStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextUnderlineStyleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWrapAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableAlignAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnElement;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelLabelAlignmentElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleSectionPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleBulletElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextOutlineLevelStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextOutlineStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class StyleEngineForIText
extends AbstractStyleEngine {
    private static final String OUTLINE = "outline";
    private Style currentStyle = null;
    private Map<Integer, StyleListProperties> currentListPropertiesMap;
    private StyleListProperties currentListProperties;
    private List<StyleTabStopProperties> currentTabStopPropertiesList;
    private List<StyleColumnProperties> currentColumnPropertiesList;
    private final PdfOptions options;
    private final Map<String, Style> stylesMap = new HashMap<String, Style>();

    public StyleEngineForIText(OdfDocument odfDocument, PdfOptions options) {
        super(odfDocument);
        this.options = options != null ? options : PdfOptions.getDefault();
    }

    public void visit(OfficeStylesElement ele) {
        super.visit(ele);
    }

    public void visit(OfficeAutomaticStylesElement ele) {
        super.visit(ele);
    }

    public void visit(OfficeMasterStylesElement ele) {
        super.visit(ele);
    }

    public void visit(StyleDefaultStyleElement ele) {
        this.computeStyle((OdfElement)ele, true);
    }

    public void visit(StyleStyleElement ele) {
        this.computeStyle((OdfElement)ele, false);
    }

    public void visit(StylePageLayoutElement ele) {
        this.computeStyle((OdfElement)ele, false);
    }

    private Style computeStyle(OdfElement odfElement, boolean isDefaultStyle) {
        OdfStyleBase parentStyleBase;
        String styleId;
        Style style;
        if (odfElement == null) {
            return null;
        }
        OdfStyleBase styleBase = odfElement instanceof OdfStyleBase ? (OdfStyleBase)odfElement : null;
        String familyName = styleBase != null ? styleBase.getFamilyName() : OUTLINE;
        String styleName = null;
        String masterPageName = null;
        if (!isDefaultStyle) {
            if (styleBase instanceof StyleStyleElement) {
                StyleStyleElement styleElement = (StyleStyleElement)styleBase;
                styleName = styleElement.getStyleNameAttribute();
                masterPageName = styleElement.getStyleMasterPageNameAttribute();
            } else if (styleBase instanceof StylePageLayoutElement) {
                styleName = ((StylePageLayoutElement)styleBase).getStyleNameAttribute();
            } else if (styleBase instanceof TextListStyleElement) {
                styleName = ((TextListStyleElement)styleBase).getStyleNameAttribute();
            }
        }
        if ((style = this.stylesMap.get(styleId = this.getStyleId(familyName, styleName))) != null) {
            return style;
        }
        style = new Style(this.options.getFontProvider(), styleName, familyName, masterPageName);
        ArrayList<Style> parentsStyles = null;
        OdfStyleBase odfStyleBase = parentStyleBase = styleBase != null ? styleBase.getParentStyle() : null;
        while (parentStyleBase != null) {
            Style parentStyle = this.computeStyle((OdfElement)parentStyleBase, isDefaultStyle);
            if (parentStyle != null) {
                if (parentsStyles == null) {
                    parentsStyles = new ArrayList<Style>();
                }
                parentsStyles.add(0, parentStyle);
            }
            parentStyleBase = parentStyleBase.getParentStyle();
        }
        if (parentsStyles != null) {
            for (Style parentsStyle : parentsStyles) {
                style.merge(parentsStyle, false);
            }
        }
        this.currentStyle = style;
        super.visit(odfElement);
        this.stylesMap.put(styleId, style);
        return style;
    }

    public void visit(StylePageLayoutPropertiesElement ele) {
        String orientation;
        String width;
        String height;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor;
        StylePageLayoutProperties pageLayoutProperties = this.currentStyle.getPageLayoutProperties();
        if (pageLayoutProperties == null) {
            pageLayoutProperties = new StylePageLayoutProperties();
            this.currentStyle.setPageLayoutProperties(pageLayoutProperties);
        }
        if (StringUtils.isNotEmpty(backgroundColor = ele.getFoBackgroundColorAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            pageLayoutProperties.setMargin(ODFUtils.getDimensionAsPoint(margin));
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            pageLayoutProperties.setMarginBottom(ODFUtils.getDimensionAsPoint(marginBottom));
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            pageLayoutProperties.setMarginLeft(ODFUtils.getDimensionAsPoint(marginLeft));
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            pageLayoutProperties.setMarginRight(ODFUtils.getDimensionAsPoint(marginRight));
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            pageLayoutProperties.setMarginTop(ODFUtils.getDimensionAsPoint(marginTop));
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(height = ele.getFoPageHeightAttribute())) {
            pageLayoutProperties.setHeight(ODFUtils.getDimensionAsPoint(height));
        }
        if (StringUtils.isNotEmpty(width = ele.getFoPageWidthAttribute())) {
            pageLayoutProperties.setWidth(ODFUtils.getDimensionAsPoint(width));
        }
        if (StringUtils.isNotEmpty(orientation = ele.getStylePrintOrientationAttribute())) {
            if (StylePrintOrientationAttribute.Value.LANDSCAPE.toString().equals(orientation)) {
                pageLayoutProperties.setOrientation(PageOrientation.Landscape);
            } else if (StylePrintOrientationAttribute.Value.PORTRAIT.toString().equals(orientation)) {
                pageLayoutProperties.setOrientation(PageOrientation.Portrait);
            }
        }
        super.visit(ele);
    }

    public void visit(StyleHeaderFooterPropertiesElement ele) {
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String minHeight;
        Node parentNode = ele.getParentNode();
        boolean footer = StyleFooterStyleElement.ELEMENT_NAME.getLocalName().equals(parentNode.getLocalName());
        StyleHeaderFooterProperties headerFooterProperties = null;
        if (!footer) {
            headerFooterProperties = this.currentStyle.getHeaderProperties();
            if (headerFooterProperties == null) {
                headerFooterProperties = new StyleHeaderFooterProperties();
                this.currentStyle.setHeaderProperties(headerFooterProperties);
            }
        } else {
            headerFooterProperties = this.currentStyle.getFooterProperties();
            if (headerFooterProperties == null) {
                headerFooterProperties = new StyleHeaderFooterProperties();
                this.currentStyle.setFooterProperties(headerFooterProperties);
            }
        }
        if (StringUtils.isNotEmpty(minHeight = ele.getFoMinHeightAttribute())) {
            headerFooterProperties.setMinHeight(ODFUtils.getDimensionAsPoint(minHeight));
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            headerFooterProperties.setMargin(ODFUtils.getDimensionAsPoint(margin));
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            headerFooterProperties.setMarginBottom(ODFUtils.getDimensionAsPoint(marginBottom));
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            headerFooterProperties.setMarginLeft(ODFUtils.getDimensionAsPoint(marginLeft));
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            headerFooterProperties.setMarginRight(ODFUtils.getDimensionAsPoint(marginRight));
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            headerFooterProperties.setMarginTop(ODFUtils.getDimensionAsPoint(marginTop));
        }
    }

    public void visit(StyleParagraphPropertiesElement ele) {
        String breakBefore;
        String keepTogether;
        String textIndent;
        Boolean autoTextIndent;
        String textAlign;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String lineHeight;
        Boolean joinBorder;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor;
        StyleParagraphProperties paragraphProperties = this.currentStyle.getParagraphProperties();
        if (paragraphProperties == null) {
            paragraphProperties = new StyleParagraphProperties();
            this.currentStyle.setParagraphProperties(paragraphProperties);
        }
        if (StringUtils.isNotEmpty(backgroundColor = ele.getFoBackgroundColorAttribute())) {
            paragraphProperties.setBackgroundColor(ColorRegistry.getInstance().getColor(backgroundColor));
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            paragraphProperties.setBorder(new StyleBorder(border, BorderType.ALL));
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            paragraphProperties.setBorderBottom(new StyleBorder(borderBottom, BorderType.BOTTOM));
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            paragraphProperties.setBorderLeft(new StyleBorder(borderLeft, BorderType.LEFT));
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            paragraphProperties.setBorderRight(new StyleBorder(borderRight, BorderType.RIGHT));
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            paragraphProperties.setBorderTop(new StyleBorder(borderTop, BorderType.TOP));
        }
        if ((joinBorder = ele.getStyleJoinBorderAttribute()) != null) {
            paragraphProperties.setJoinBorder(joinBorder);
        }
        if (StringUtils.isNotEmpty(lineHeight = ele.getFoLineHeightAttribute())) {
            paragraphProperties.setLineHeight(new StyleLineHeight(ODFUtils.getDimensionAsPoint(lineHeight), ODFUtils.hasPercentUnit(lineHeight)));
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            paragraphProperties.setMargin(ODFUtils.getDimensionAsPoint(margin));
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            paragraphProperties.setMarginBottom(ODFUtils.getDimensionAsPoint(marginBottom));
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            paragraphProperties.setMarginLeft(ODFUtils.getDimensionAsPoint(marginLeft));
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            paragraphProperties.setMarginRight(ODFUtils.getDimensionAsPoint(marginRight));
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            paragraphProperties.setMarginTop(ODFUtils.getDimensionAsPoint(marginTop));
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            paragraphProperties.setPadding(ODFUtils.getDimensionAsPoint(padding));
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            paragraphProperties.setPaddingBottom(ODFUtils.getDimensionAsPoint(paddingBottom));
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            paragraphProperties.setPaddingLeft(ODFUtils.getDimensionAsPoint(paddingLeft));
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            paragraphProperties.setPaddingRight(ODFUtils.getDimensionAsPoint(paddingRight));
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            paragraphProperties.setPaddingTop(ODFUtils.getDimensionAsPoint(paddingTop));
        }
        if (StringUtils.isNotEmpty(textAlign = ele.getFoTextAlignAttribute())) {
            int alignment = -1;
            if (FoTextAlignAttribute.Value.START.toString().equals(textAlign)) {
                alignment = 0;
            } else if (FoTextAlignAttribute.Value.END.toString().equals(textAlign)) {
                alignment = 2;
            } else if (FoTextAlignAttribute.Value.LEFT.toString().equals(textAlign)) {
                alignment = 0;
            } else if (FoTextAlignAttribute.Value.RIGHT.toString().equals(textAlign)) {
                alignment = 2;
            } else if (FoTextAlignAttribute.Value.CENTER.toString().equals(textAlign)) {
                alignment = 1;
            } else if (FoTextAlignAttribute.Value.JUSTIFY.toString().equals(textAlign)) {
                alignment = 3;
            }
            paragraphProperties.setAlignment(alignment);
        }
        if ((autoTextIndent = ele.getStyleAutoTextIndentAttribute()) != null) {
            paragraphProperties.setAutoTextIndent(autoTextIndent);
        }
        if (StringUtils.isNotEmpty(textIndent = ele.getFoTextIndentAttribute())) {
            paragraphProperties.setTextIndent(ODFUtils.getDimensionAsPoint(textIndent));
        }
        if (StringUtils.isNotEmpty(keepTogether = ele.getFoKeepTogetherAttribute())) {
            if (FoKeepTogetherAttribute.Value.ALWAYS.toString().equals(keepTogether)) {
                paragraphProperties.setKeepTogether(Boolean.TRUE);
            } else {
                paragraphProperties.setKeepTogether(Boolean.FALSE);
            }
        }
        if (StringUtils.isNotEmpty(breakBefore = ele.getFoBreakBeforeAttribute())) {
            if (FoBreakBeforeAttribute.Value.PAGE.toString().equals(breakBefore)) {
                paragraphProperties.setBreakBefore(StyleBreak.createWithPageBreak());
            } else if (FoBreakBeforeAttribute.Value.COLUMN.toString().equals(breakBefore)) {
                paragraphProperties.setBreakBefore(StyleBreak.createWithColumnBreak());
            } else {
                paragraphProperties.setBreakBefore(StyleBreak.createWithNoBreak());
            }
        }
        super.visit(ele);
    }

    public void visit(StyleTabStopsElement ele) {
        this.currentTabStopPropertiesList = new ArrayList<StyleTabStopProperties>();
        super.visit(ele);
        this.currentStyle.setTabStopPropertiesList(this.currentTabStopPropertiesList);
        this.currentTabStopPropertiesList = null;
    }

    public void visit(StyleTabStopElement ele) {
        String type;
        String position;
        if (this.currentTabStopPropertiesList == null) {
            return;
        }
        StyleTabStopProperties tabStopProperties = new StyleTabStopProperties();
        this.currentTabStopPropertiesList.add(tabStopProperties);
        String leaderText = ele.getStyleLeaderTextAttribute();
        if (StringUtils.isNotEmpty(leaderText)) {
            tabStopProperties.setLeaderText(leaderText);
        }
        if (StringUtils.isNotEmpty(position = ele.getStylePositionAttribute())) {
            tabStopProperties.setPosition(ODFUtils.getDimensionAsPoint(position));
        }
        if (StringUtils.isNotEmpty(type = ele.getStyleTypeAttribute())) {
            if (StyleTypeAttribute.Value.LEFT.toString().equals(type)) {
                tabStopProperties.setType(0);
            } else if (StyleTypeAttribute.Value.RIGHT.toString().equals(type)) {
                tabStopProperties.setType(2);
            } else {
                tabStopProperties.setType(1);
            }
        }
        super.visit(ele);
    }

    public void visit(StyleTextPropertiesElement ele) {
        String textPositionStyle;
        String lineThroughStyle;
        String underlineType;
        String underlineStyle;
        String fontWeightComplex;
        String fontWeightAsian;
        String fontWeight;
        String fontVariant;
        String fontStyleComplex;
        String fontStyleAsian;
        String fontStyle;
        String fontSizeComplex;
        String fontSizeAsian;
        String fontSize;
        String fontNameComplex;
        String fontNameAsian;
        String fontName;
        String fontFamilyComplex;
        String fontFamilyAsian;
        String fontFamily;
        String color;
        StyleTextProperties textProperties = this.currentStyle.getTextProperties();
        if (textProperties == null) {
            textProperties = new StyleTextProperties(this.options.getFontProvider());
            this.currentStyle.setTextProperties(textProperties);
        }
        textProperties.setFontEncoding(this.options.getFontEncoding());
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            textProperties.setBackgroundColor(ColorRegistry.getInstance().getColor(backgroundColor));
        }
        if (StringUtils.isNotEmpty(color = ele.getFoColorAttribute())) {
            textProperties.setFontColor(ColorRegistry.getInstance().getColor(color));
        }
        if (StringUtils.isNotEmpty(fontFamily = ele.getFoFontFamilyAttribute())) {
            textProperties.setFontName(ODFUtils.stripTrailingDigits(fontFamily));
        }
        if (StringUtils.isNotEmpty(fontFamilyAsian = ele.getStyleFontFamilyAsianAttribute())) {
            textProperties.setFontNameAsian(ODFUtils.stripTrailingDigits(fontFamilyAsian));
        }
        if (StringUtils.isNotEmpty(fontFamilyComplex = ele.getStyleFontFamilyComplexAttribute())) {
            textProperties.setFontNameComplex(ODFUtils.stripTrailingDigits(fontFamilyComplex));
        }
        if (StringUtils.isNotEmpty(fontName = ele.getStyleFontNameAttribute())) {
            textProperties.setFontName(ODFUtils.stripTrailingDigits(fontName));
        }
        if (StringUtils.isNotEmpty(fontNameAsian = ele.getStyleFontNameAsianAttribute())) {
            textProperties.setFontNameAsian(ODFUtils.stripTrailingDigits(fontNameAsian));
        }
        if (StringUtils.isNotEmpty(fontNameComplex = ele.getStyleFontNameComplexAttribute())) {
            textProperties.setFontNameComplex(ODFUtils.stripTrailingDigits(fontNameComplex));
        }
        if (StringUtils.isNotEmpty(fontSize = ele.getFoFontSizeAttribute())) {
            if (ODFUtils.hasPercentUnit(fontSize)) {
                if (textProperties.getFontSize() != -1.0f) {
                    textProperties.setFontSize(textProperties.getFontSize() * ODFUtils.getDimensionAsPoint(fontSize).floatValue());
                }
            } else {
                textProperties.setFontSize(ODFUtils.getDimensionAsPoint(fontSize).floatValue());
            }
        }
        if (StringUtils.isNotEmpty(fontSizeAsian = ele.getStyleFontSizeAsianAttribute())) {
            if (ODFUtils.hasPercentUnit(fontSizeAsian)) {
                if (textProperties.getFontSizeAsian() != -1.0f) {
                    textProperties.setFontSizeAsian(textProperties.getFontSizeAsian() * ODFUtils.getDimensionAsPoint(fontSizeAsian).floatValue());
                }
            } else {
                textProperties.setFontSizeAsian(ODFUtils.getDimensionAsPoint(fontSizeAsian).floatValue());
            }
        }
        if (StringUtils.isNotEmpty(fontSizeComplex = ele.getStyleFontSizeComplexAttribute())) {
            if (ODFUtils.hasPercentUnit(fontSizeComplex)) {
                if (textProperties.getFontSizeComplex() != -1.0f) {
                    textProperties.setFontSizeComplex(textProperties.getFontSizeComplex() * ODFUtils.getDimensionAsPoint(fontSizeComplex).floatValue());
                }
            } else {
                textProperties.setFontSizeComplex(ODFUtils.getDimensionAsPoint(fontSizeComplex).floatValue());
            }
        }
        if (StringUtils.isNotEmpty(fontStyle = ele.getFoFontStyleAttribute())) {
            if (FoFontStyleAttribute.Value.NORMAL.toString().equals(fontStyle)) {
                textProperties.setFontItalic(Boolean.FALSE);
            } else {
                textProperties.setFontItalic(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(fontStyleAsian = ele.getStyleFontStyleAsianAttribute())) {
            if (StyleFontStyleAsianAttribute.Value.NORMAL.toString().equals(fontStyleAsian)) {
                textProperties.setFontItalicAsian(Boolean.FALSE);
            } else {
                textProperties.setFontItalicAsian(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(fontStyleComplex = ele.getStyleFontStyleComplexAttribute())) {
            if (StyleFontStyleComplexAttribute.Value.NORMAL.toString().equals(fontStyleComplex)) {
                textProperties.setFontItalicComplex(Boolean.FALSE);
            } else {
                textProperties.setFontItalicComplex(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(fontVariant = ele.getFoFontVariantAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(fontWeight = ele.getFoFontWeightAttribute())) {
            if (FoFontWeightAttribute.Value.NORMAL.toString().equals(fontWeight)) {
                textProperties.setFontBold(Boolean.FALSE);
            } else {
                textProperties.setFontBold(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(fontWeightAsian = ele.getStyleFontWeightAsianAttribute())) {
            if (StyleFontWeightAsianAttribute.Value.NORMAL.toString().equals(fontWeightAsian)) {
                textProperties.setFontBoldAsian(Boolean.FALSE);
            } else {
                textProperties.setFontBoldAsian(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(fontWeightComplex = ele.getStyleFontWeightComplexAttribute())) {
            if (StyleFontWeightComplexAttribute.Value.NORMAL.toString().equals(fontWeightComplex)) {
                textProperties.setFontBoldComplex(Boolean.FALSE);
            } else {
                textProperties.setFontBoldComplex(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(underlineStyle = ele.getStyleTextUnderlineStyleAttribute())) {
            if (StyleTextUnderlineStyleAttribute.Value.NONE.toString().equals(underlineStyle)) {
                textProperties.setFontUnderline(Boolean.FALSE);
            } else {
                textProperties.setFontUnderline(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(underlineType = ele.getStyleTextUnderlineTypeAttribute())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty(lineThroughStyle = ele.getStyleTextLineThroughStyleAttribute())) {
            if (StyleTextLineThroughStyleAttribute.Value.NONE.toString().equals(lineThroughStyle)) {
                textProperties.setFontStrikeThru(Boolean.FALSE);
            } else {
                textProperties.setFontStrikeThru(Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty(textPositionStyle = ele.getStyleTextPositionAttribute())) {
            if (textPositionStyle.contains("super")) {
                textProperties.setTextPosition(Float.valueOf(5.0f));
            } else if (textPositionStyle.contains("sub")) {
                textProperties.setTextPosition(Float.valueOf(-2.0f));
            }
        }
        super.visit(ele);
    }

    public void visit(StyleTablePropertiesElement ele) {
        Boolean mayBreakBetweenRows;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String align;
        String width;
        StyleTableProperties tableProperties = new StyleTableProperties();
        this.currentStyle.setTableProperties(tableProperties);
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            tableProperties.setBackgroundColor(ColorRegistry.getInstance().getColor(backgroundColor));
        }
        if (StringUtils.isNotEmpty(width = ele.getStyleWidthAttribute())) {
            tableProperties.setWidth(ODFUtils.getDimensionAsPoint(width));
        }
        if (StringUtils.isNotEmpty(align = ele.getTableAlignAttribute())) {
            if (TableAlignAttribute.Value.LEFT.toString().equals(align)) {
                tableProperties.setAlignment(0);
            } else if (TableAlignAttribute.Value.RIGHT.toString().equals(align)) {
                tableProperties.setAlignment(2);
            } else {
                tableProperties.setAlignment(1);
            }
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            tableProperties.setMargin(ODFUtils.getDimensionAsPoint(margin));
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            tableProperties.setMarginBottom(ODFUtils.getDimensionAsPoint(marginBottom));
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            tableProperties.setMarginLeft(ODFUtils.getDimensionAsPoint(marginLeft));
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            tableProperties.setMarginRight(ODFUtils.getDimensionAsPoint(marginRight));
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            tableProperties.setMarginTop(ODFUtils.getDimensionAsPoint(marginTop));
        }
        if ((mayBreakBetweenRows = ele.getStyleMayBreakBetweenRowsAttribute()) != null) {
            tableProperties.setMayBreakBetweenRows(mayBreakBetweenRows);
        }
        super.visit(ele);
    }

    public void visit(StyleTableRowPropertiesElement ele) {
        String keepTogether;
        String height;
        String minHeight;
        StyleTableRowProperties tableRowProperties = this.currentStyle.getTableRowProperties();
        if (tableRowProperties == null) {
            tableRowProperties = new StyleTableRowProperties();
            this.currentStyle.setTableRowProperties(tableRowProperties);
        }
        if (StringUtils.isNotEmpty(minHeight = ele.getStyleMinRowHeightAttribute())) {
            tableRowProperties.setMinRowHeight(ODFUtils.getDimensionAsPoint(minHeight));
        }
        if (StringUtils.isNotEmpty(height = ele.getStyleRowHeightAttribute())) {
            tableRowProperties.setRowHeight(ODFUtils.getDimensionAsPoint(height));
        }
        if (StringUtils.isNotEmpty(keepTogether = ele.getFoKeepTogetherAttribute())) {
            if (FoKeepTogetherAttribute.Value.ALWAYS.toString().equals(keepTogether)) {
                tableRowProperties.setKeepTogether(Boolean.TRUE);
            } else {
                tableRowProperties.setKeepTogether(Boolean.FALSE);
            }
        }
    }

    public void visit(StyleTableCellPropertiesElement ele) {
        String verticalAlign;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor;
        StyleTableCellProperties tableCellProperties = this.currentStyle.getTableCellProperties();
        if (tableCellProperties == null) {
            tableCellProperties = new StyleTableCellProperties();
            this.currentStyle.setTableCellProperties(tableCellProperties);
        }
        if (StringUtils.isNotEmpty(backgroundColor = ele.getFoBackgroundColorAttribute())) {
            tableCellProperties.setBackgroundColor(ColorRegistry.getInstance().getColor(backgroundColor));
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            tableCellProperties.setBorder(new StyleBorder(border, BorderType.ALL));
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            tableCellProperties.setBorderBottom(new StyleBorder(borderBottom, BorderType.BOTTOM));
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            tableCellProperties.setBorderLeft(new StyleBorder(borderLeft, BorderType.LEFT));
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            tableCellProperties.setBorderRight(new StyleBorder(borderRight, BorderType.RIGHT));
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            tableCellProperties.setBorderTop(new StyleBorder(borderTop, BorderType.TOP));
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            tableCellProperties.setPadding(ODFUtils.getDimensionAsPoint(padding));
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            tableCellProperties.setPaddingBottom(ODFUtils.getDimensionAsPoint(paddingBottom));
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            tableCellProperties.setPaddingLeft(ODFUtils.getDimensionAsPoint(paddingLeft));
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            tableCellProperties.setPaddingRight(ODFUtils.getDimensionAsPoint(paddingRight));
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            tableCellProperties.setPaddingTop(ODFUtils.getDimensionAsPoint(paddingTop));
        }
        if (StringUtils.isNotEmpty(verticalAlign = ele.getStyleVerticalAlignAttribute())) {
            if (StyleVerticalAlignAttribute.Value.BASELINE.toString().equals(verticalAlign)) {
                tableCellProperties.setVerticalAlignment(7);
            } else if (StyleVerticalAlignAttribute.Value.TOP.toString().equals(verticalAlign)) {
                tableCellProperties.setVerticalAlignment(4);
            } else if (StyleVerticalAlignAttribute.Value.MIDDLE.toString().equals(verticalAlign)) {
                tableCellProperties.setVerticalAlignment(5);
            } else if (StyleVerticalAlignAttribute.Value.BOTTOM.toString().equals(verticalAlign)) {
                tableCellProperties.setVerticalAlignment(6);
            }
        }
        super.visit(ele);
    }

    public void visit(StyleGraphicPropertiesElement ele) {
        String wrap;
        StyleGraphicProperties graphicProperties = this.currentStyle.getGraphicProperties();
        if (graphicProperties == null) {
            graphicProperties = new StyleGraphicProperties();
            this.currentStyle.setGraphicProperties(graphicProperties);
        }
        if (StringUtils.isNotEmpty(wrap = ele.getStyleWrapAttribute())) {
            if (StyleWrapAttribute.Value.RUN_THROUGH.toString().equals(wrap)) {
                graphicProperties.setRunThrough(Boolean.TRUE);
            } else {
                graphicProperties.setRunThrough(Boolean.FALSE);
            }
        }
        super.visit(ele);
    }

    public void visit(TextListStyleElement ele) {
        this.currentListPropertiesMap = new HashMap<Integer, StyleListProperties>();
        this.computeStyle((OdfElement)ele, false);
        this.currentStyle.setListPropertiesMap(this.currentListPropertiesMap);
        this.currentListPropertiesMap = null;
    }

    public void visit(TextListLevelStyleBulletElement ele) {
        String numSuffix;
        String numPrefix;
        String bulletChar;
        Style style;
        Integer textLevel = ele.getTextLevelAttribute();
        if (this.currentListPropertiesMap == null || textLevel == null) {
            return;
        }
        StyleListProperties listProperties = new StyleListProperties();
        this.currentListPropertiesMap.put(textLevel, listProperties);
        String styleName = ele.getTextStyleNameAttribute();
        if (StringUtils.isNotEmpty(styleName) && (style = this.getStyle(OdfStyleFamily.Text.getName(), styleName, null)) != null) {
            listProperties.setTextProperties(style.getTextProperties());
        }
        if (StringUtils.isNotEmpty(bulletChar = ele.getTextBulletCharAttribute())) {
            listProperties.setBulletChar(bulletChar);
        }
        if (StringUtils.isNotEmpty(numPrefix = ele.getStyleNumPrefixAttribute())) {
            listProperties.setNumPrefix(numPrefix);
        }
        if (StringUtils.isNotEmpty(numSuffix = ele.getStyleNumSuffixAttribute())) {
            listProperties.setNumSuffix(numSuffix);
        }
        this.currentListProperties = listProperties;
        super.visit(ele);
        this.currentListProperties = null;
    }

    public void visit(TextListLevelStyleImageElement ele) {
        Image imageObj;
        byte[] imageStream;
        Integer textLevel = ele.getTextLevelAttribute();
        if (this.currentListPropertiesMap == null || textLevel == null) {
            return;
        }
        StyleListProperties listProperties = new StyleListProperties();
        this.currentListPropertiesMap.put(textLevel, listProperties);
        String href = ele.getXlinkHrefAttribute();
        if (StringUtils.isNotEmpty(href) && (imageStream = this.odfDocument.getPackage().getBytes(href)) != null && (imageObj = StylableImage.getImage(imageStream)) != null) {
            listProperties.setImage(imageObj);
        }
        this.currentListProperties = listProperties;
        super.visit(ele);
        this.currentListProperties = null;
    }

    public void visit(TextListLevelStyleNumberElement ele) {
        String numFormat;
        String numSuffix;
        String numPrefix;
        Integer displayLevels;
        Integer startValue;
        Style style;
        Integer textLevel = ele.getTextLevelAttribute();
        if (this.currentListPropertiesMap == null || textLevel == null) {
            return;
        }
        StyleListProperties listProperties = new StyleListProperties();
        this.currentListPropertiesMap.put(textLevel, listProperties);
        String styleName = ele.getTextStyleNameAttribute();
        if (StringUtils.isNotEmpty(styleName) && (style = this.getStyle(OdfStyleFamily.Text.getName(), styleName, null)) != null) {
            listProperties.setTextProperties(style.getTextProperties());
        }
        if ((startValue = ele.getTextStartValueAttribute()) != null) {
            listProperties.setStartValue(startValue);
        }
        if ((displayLevels = ele.getTextDisplayLevelsAttribute()) != null) {
            listProperties.setDisplayLevels(displayLevels);
        }
        if (StringUtils.isNotEmpty(numPrefix = ele.getStyleNumPrefixAttribute())) {
            listProperties.setNumPrefix(numPrefix);
        }
        if (StringUtils.isNotEmpty(numSuffix = ele.getStyleNumSuffixAttribute())) {
            listProperties.setNumSuffix(numSuffix);
        }
        if (StringUtils.isNotEmpty(numFormat = ele.getStyleNumFormatAttribute())) {
            if (StyleNumFormatAttribute.Value.a.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createAlphabetical(true));
            } else if (StyleNumFormatAttribute.Value.A.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createAlphabetical(false));
            } else if (StyleNumFormatAttribute.Value.i.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createRoman(true));
            } else if (StyleNumFormatAttribute.Value.I.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createRoman(false));
            } else {
                listProperties.setNumFormat(StyleNumFormat.createNumerical());
            }
        }
        this.currentListProperties = listProperties;
        super.visit(ele);
        this.currentListProperties = null;
    }

    public void visit(StyleListLevelPropertiesElement ele) {
        String minLabelWidth;
        String spaceBefore;
        String height;
        if (this.currentListProperties == null) {
            return;
        }
        StyleListProperties listProperties = this.currentListProperties;
        String width = ele.getFoWidthAttribute();
        if (StringUtils.isNotEmpty(width)) {
            listProperties.setWidth(ODFUtils.getDimensionAsPoint(width));
        }
        if (StringUtils.isNotEmpty(height = ele.getFoHeightAttribute())) {
            listProperties.setHeight(ODFUtils.getDimensionAsPoint(height));
        }
        if (StringUtils.isNotEmpty(spaceBefore = ele.getTextSpaceBeforeAttribute())) {
            listProperties.setSpaceBefore(ODFUtils.getDimensionAsPoint(spaceBefore));
        }
        if (StringUtils.isNotEmpty(minLabelWidth = ele.getTextMinLabelWidthAttribute())) {
            listProperties.setMinLabelWidth(ODFUtils.getDimensionAsPoint(minLabelWidth));
        }
        super.visit(ele);
    }

    public void visit(StyleListLevelLabelAlignmentElement ele) {
        String textIndent;
        if (this.currentListProperties == null) {
            return;
        }
        StyleListProperties listProperties = this.currentListProperties;
        String marginLeft = ele.getFoMarginLeftAttribute();
        if (StringUtils.isNotEmpty(marginLeft)) {
            listProperties.setMarginLeft(ODFUtils.getDimensionAsPoint(marginLeft));
        }
        if (StringUtils.isNotEmpty(textIndent = ele.getFoTextIndentAttribute())) {
            listProperties.setTextIndent(ODFUtils.getDimensionAsPoint(textIndent));
        }
        super.visit(ele);
    }

    public void visit(TextOutlineStyleElement ele) {
        this.currentListPropertiesMap = new HashMap<Integer, StyleListProperties>();
        this.computeStyle((OdfElement)ele, true);
        this.currentStyle.setOutlinePropertiesMap(this.currentListPropertiesMap);
        this.currentListPropertiesMap = null;
    }

    public void visit(TextOutlineLevelStyleElement ele) {
        String numFormat;
        String numSuffix;
        String numPrefix;
        Integer displayLevels;
        Integer startValue;
        Style style;
        Integer textLevel = ele.getTextLevelAttribute();
        if (this.currentListPropertiesMap == null || textLevel == null) {
            return;
        }
        StyleListProperties listProperties = new StyleListProperties();
        this.currentListPropertiesMap.put(textLevel, listProperties);
        String styleName = ele.getTextStyleNameAttribute();
        if (StringUtils.isNotEmpty(styleName) && (style = this.getStyle(OdfStyleFamily.Text.getName(), styleName, null)) != null) {
            listProperties.setTextProperties(style.getTextProperties());
        }
        if ((startValue = ele.getTextStartValueAttribute()) != null) {
            listProperties.setStartValue(startValue);
        }
        if ((displayLevels = ele.getTextDisplayLevelsAttribute()) != null) {
            listProperties.setDisplayLevels(displayLevels);
        }
        if (StringUtils.isNotEmpty(numPrefix = ele.getStyleNumPrefixAttribute())) {
            listProperties.setNumPrefix(numPrefix);
        }
        if (StringUtils.isNotEmpty(numSuffix = ele.getStyleNumSuffixAttribute())) {
            listProperties.setNumSuffix(numSuffix);
        }
        if (StringUtils.isNotEmpty(numFormat = ele.getStyleNumFormatAttribute())) {
            if (StyleNumFormatAttribute.Value.a.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createAlphabetical(true));
            } else if (StyleNumFormatAttribute.Value.A.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createAlphabetical(false));
            } else if (StyleNumFormatAttribute.Value.i.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createRoman(true));
            } else if (StyleNumFormatAttribute.Value.I.toString().equals(numFormat)) {
                listProperties.setNumFormat(StyleNumFormat.createRoman(false));
            } else {
                listProperties.setNumFormat(StyleNumFormat.createNumerical());
            }
        }
        this.currentListProperties = listProperties;
        super.visit(ele);
        this.currentListProperties = null;
    }

    public void visit(StyleSectionPropertiesElement ele) {
        String marginRight;
        String marginLeft;
        Boolean dontBalanceTextColumns;
        String backgroundColor;
        StyleSectionProperties sectionProperties = this.currentStyle.getSectionProperties();
        if (sectionProperties == null) {
            sectionProperties = new StyleSectionProperties();
            this.currentStyle.setSectionProperties(sectionProperties);
        }
        if (StringUtils.isNotEmpty(backgroundColor = ele.getFoBackgroundColorAttribute())) {
            sectionProperties.setBackgroundColor(ColorRegistry.getInstance().getColor(backgroundColor));
        }
        if ((dontBalanceTextColumns = ele.getTextDontBalanceTextColumnsAttribute()) != null) {
            sectionProperties.setDontBalanceTextColumns(dontBalanceTextColumns);
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            sectionProperties.setMarginLeft(ODFUtils.getDimensionAsPoint(marginLeft));
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            sectionProperties.setMarginRight(ODFUtils.getDimensionAsPoint(marginRight));
        }
        super.visit(ele);
    }

    public void visit(StyleColumnsElement ele) {
        String columnGap;
        Integer columnCount;
        StyleSectionProperties sectionProperties = this.currentStyle.getSectionProperties();
        if (sectionProperties == null) {
            sectionProperties = new StyleSectionProperties();
            this.currentStyle.setSectionProperties(sectionProperties);
        }
        if ((columnCount = ele.getFoColumnCountAttribute()) != null) {
            sectionProperties.setColumnCount(columnCount);
        }
        if (StringUtils.isNotEmpty(columnGap = ele.getFoColumnGapAttribute())) {
            sectionProperties.setColumnGap(ODFUtils.getDimensionAsPoint(columnGap));
        }
        this.currentColumnPropertiesList = new ArrayList<StyleColumnProperties>();
        super.visit(ele);
        this.currentStyle.setColumnPropertiesList(this.currentColumnPropertiesList);
        this.currentColumnPropertiesList = null;
    }

    public void visit(StyleColumnElement ele) {
        String endIndent;
        String startIndent;
        if (this.currentColumnPropertiesList == null) {
            return;
        }
        StyleColumnProperties columnProperties = new StyleColumnProperties();
        this.currentColumnPropertiesList.add(columnProperties);
        String relWidth = ele.getStyleRelWidthAttribute();
        if (StringUtils.isNotEmpty(relWidth)) {
            columnProperties.setRelWidth(ODFUtils.getRelativeSize(relWidth));
        }
        if (StringUtils.isNotEmpty(startIndent = ele.getFoStartIndentAttribute())) {
            columnProperties.setStartIndent(ODFUtils.getDimensionAsPoint(startIndent));
        }
        if (StringUtils.isNotEmpty(endIndent = ele.getFoEndIndentAttribute())) {
            columnProperties.setEndIndent(ODFUtils.getDimensionAsPoint(endIndent));
        }
        super.visit(ele);
    }

    private String getStyleId(String familyName, String styleName) {
        StringBuilder className = new StringBuilder();
        className.append(familyName);
        if (styleName != null) {
            className.append('_');
            className.append(StringUtils.replaceAll(styleName, ".", "_"));
        }
        return className.toString();
    }

    private Style getStyle(String familyName, String styleName) {
        return this.stylesMap.get(this.getStyleId(familyName, styleName));
    }

    public Style getStyle(String familyName, String styleName, Style parentElementStyle) {
        String newStyleName = null;
        String newFamilyName = null;
        String newMasterPageName = null;
        Style style = this.getStyle(familyName, styleName);
        if (style != null) {
            newStyleName = style.getStyleName();
            newFamilyName = style.getFamilyName();
            newMasterPageName = style.getMasterPageName();
        } else if (parentElementStyle != null) {
            newStyleName = parentElementStyle.getStyleName();
            newFamilyName = parentElementStyle.getFamilyName();
            newMasterPageName = parentElementStyle.getMasterPageName();
        }
        Style newStyle = new Style(this.options.getFontProvider(), newStyleName, newFamilyName, newMasterPageName);
        if (parentElementStyle != null) {
            newStyle.merge(parentElementStyle, true);
        } else {
            for (Style s : this.stylesMap.values()) {
                if (s.getStyleName() != null) continue;
                newStyle.merge(s, true);
            }
        }
        if (style != null) {
            newStyle.merge(style, true);
        }
        return newStyle;
    }
}

