/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.Font;
import fr.opensagres.xdocreport.itext.extension.ExtendedChunk;
import fr.opensagres.xdocreport.itext.extension.font.FontGroup;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableElement;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylableChunk
extends ExtendedChunk
implements IStylableElement {
    private final IStylableContainer parent;
    private final FontGroup fontGroup;
    private Style lastStyleApplied = null;

    public StylableChunk(StylableDocument ownerDocument, IStylableContainer parent, String textContent, FontGroup fontGroup) {
        super(ownerDocument, textContent);
        this.parent = parent;
        this.fontGroup = fontGroup;
    }

    @Override
    public void applyStyles(Style style) {
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null) {
            Float textRise;
            Color backgroundColor;
            Font font = null;
            if (FontGroup.WESTERN.equals((Object)this.fontGroup)) {
                font = textProperties.getFont();
            } else if (FontGroup.ASIAN.equals((Object)this.fontGroup)) {
                font = textProperties.getFontAsian();
            } else if (FontGroup.COMPLEX.equals((Object)this.fontGroup)) {
                font = textProperties.getFontComplex();
            }
            if (font != null) {
                super.setFont(font);
            }
            if ((backgroundColor = textProperties.getBackgroundColor()) != null) {
                super.setBackground(backgroundColor);
            }
            if ((textRise = textProperties.getTextPosition()) != null) {
                super.setTextRise(textRise.floatValue());
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this;
    }

    public static List<StylableChunk> createChunks(StylableDocument ownerDocument, IStylableContainer parent, String textContent) {
        StyleTextProperties textProperties;
        ArrayList<StylableChunk> list = new ArrayList<StylableChunk>();
        StringBuilder sbuf = new StringBuilder();
        Font font = null;
        Font fontAsian = null;
        Font fontComplex = null;
        if (parent != null && parent.getLastStyleApplied() != null && (textProperties = parent.getLastStyleApplied().getTextProperties()) != null) {
            font = textProperties.getFont();
            fontAsian = textProperties.getFontAsian();
            fontComplex = textProperties.getFontComplex();
        }
        FontGroup currentGroup = FontGroup.WESTERN;
        for (int i = 0; i < textContent.length(); ++i) {
            char ch = textContent.charAt(i);
            FontGroup group = FontGroup.getUnicodeGroup(ch, font, fontAsian, fontComplex);
            if (sbuf.length() == 0 || currentGroup.equals((Object)group)) {
                sbuf.append(ch);
            } else {
                StylableChunk chunk = ownerDocument.createChunk(parent, sbuf.toString(), currentGroup);
                list.add(chunk);
                sbuf.setLength(0);
                sbuf.append(ch);
            }
            currentGroup = group;
        }
        StylableChunk chunk = ownerDocument.createChunk(parent, sbuf.toString(), currentGroup);
        list.add(chunk);
        return list;
    }
}

