/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.styles;

import fr.opensagres.xdocreport.utils.BorderType;
import java.awt.Color;
import org.odftoolkit.odfdom.converter.core.utils.ODFUtils;
import org.odftoolkit.odfdom.converter.pdf.internal.ColorRegistry;

public class StyleBorder {
    private final BorderType borderType;
    private boolean noBorder = false;
    private Color color;
    private Float width;

    public StyleBorder(String border, BorderType borderType) {
        this.borderType = borderType;
        this.noBorder = "none".equals(border);
        if (this.noBorder) {
            return;
        }
        String[] s = border.split(" ");
        block4: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.width = ODFUtils.getDimensionAsPoint(s[i]);
                    continue block4;
                }
                case 2: {
                    this.color = ColorRegistry.getInstance().getColor(s[i]);
                }
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Float getWidth() {
        return this.width;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public boolean isNoBorder() {
        return this.noBorder;
    }

    public BorderType getBorderType() {
        return this.borderType;
    }
}

