/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.styles;

import com.lowagie.text.Font;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.awt.Color;

public class StyleTextProperties {
    private Color backgroundColor;
    private Boolean fontBold;
    private Boolean fontBoldAsian;
    private Boolean fontBoldComplex;
    private Color fontColor;
    private String fontEncoding;
    private Boolean fontItalic;
    private Boolean fontItalicAsian;
    private Boolean fontItalicComplex;
    private String fontName;
    private String fontNameAsian;
    private String fontNameComplex;
    private float fontSize = -1.0f;
    private float fontSizeAsian = -1.0f;
    private float fontSizeComplex = -1.0f;
    private Boolean fontStrikeThru;
    private Boolean fontUnderline;
    private Float textPosition;
    private final IFontProvider fontProvider;

    public StyleTextProperties(IFontProvider fontProvider) {
        this.fontProvider = fontProvider;
    }

    public StyleTextProperties(IFontProvider fontProvider, StyleTextProperties textProperties) {
        if (textProperties != null) {
            this.merge(textProperties);
        }
        this.fontProvider = fontProvider;
    }

    public StyleTextProperties(IFontProvider fontProvider, StyleTextProperties textProperties1, StyleTextProperties textProperties2) {
        if (textProperties1 != null) {
            this.merge(textProperties1);
        }
        if (textProperties2 != null) {
            this.merge(textProperties2);
        }
        this.fontProvider = fontProvider;
    }

    public void merge(StyleTextProperties textProperties) {
        if (textProperties.getBackgroundColor() != null) {
            this.backgroundColor = textProperties.getBackgroundColor();
        }
        if (textProperties.getFontBold() != null) {
            this.fontBold = textProperties.getFontBold();
        }
        if (textProperties.getFontBoldAsian() != null) {
            this.fontBoldAsian = textProperties.getFontBoldAsian();
        }
        if (textProperties.getFontBoldComplex() != null) {
            this.fontBoldComplex = textProperties.getFontBoldComplex();
        }
        if (textProperties.getFontColor() != null) {
            this.fontColor = textProperties.getFontColor();
        }
        if (textProperties.getFontEncoding() != null) {
            this.fontEncoding = textProperties.getFontEncoding();
        }
        if (textProperties.getFontItalic() != null) {
            this.fontItalic = textProperties.getFontItalic();
        }
        if (textProperties.getFontItalicAsian() != null) {
            this.fontItalicAsian = textProperties.getFontItalicAsian();
        }
        if (textProperties.getFontItalicComplex() != null) {
            this.fontItalicComplex = textProperties.getFontItalicComplex();
        }
        if (textProperties.getFontName() != null) {
            this.fontName = textProperties.getFontName();
        }
        if (textProperties.getFontNameAsian() != null) {
            this.fontNameAsian = textProperties.getFontNameAsian();
        }
        if (textProperties.getFontNameComplex() != null) {
            this.fontNameComplex = textProperties.getFontNameComplex();
        }
        if (textProperties.getFontSize() != -1.0f) {
            this.fontSize = textProperties.getFontSize();
        }
        if (textProperties.getFontSizeAsian() != -1.0f) {
            this.fontSizeAsian = textProperties.getFontSizeAsian();
        }
        if (textProperties.getFontSizeComplex() != -1.0f) {
            this.fontSizeComplex = textProperties.getFontSizeComplex();
        }
        if (textProperties.getFontStrikeThru() != null) {
            this.fontStrikeThru = textProperties.getFontStrikeThru();
        }
        if (textProperties.getFontUnderline() != null) {
            this.fontUnderline = textProperties.getFontUnderline();
        }
        if (textProperties.getTextPosition() != null) {
            this.textPosition = textProperties.getTextPosition();
        }
    }

    public int getStyleFlag() {
        int style = 0;
        if (Boolean.TRUE.equals(this.fontItalic)) {
            style |= 2;
        }
        if (Boolean.TRUE.equals(this.fontBold)) {
            style |= 1;
        }
        if (Boolean.TRUE.equals(this.fontUnderline)) {
            style |= 4;
        }
        if (Boolean.TRUE.equals(this.fontStrikeThru)) {
            style |= 8;
        }
        return style;
    }

    public int getStyleFlagAsian() {
        int style = 0;
        if (Boolean.TRUE.equals(this.fontItalicAsian)) {
            style |= 2;
        }
        if (Boolean.TRUE.equals(this.fontBoldAsian)) {
            style |= 1;
        }
        if (Boolean.TRUE.equals(this.fontUnderline)) {
            style |= 4;
        }
        if (Boolean.TRUE.equals(this.fontStrikeThru)) {
            style |= 8;
        }
        return style;
    }

    public int getStyleFlagComplex() {
        int style = 0;
        if (Boolean.TRUE.equals(this.fontItalicComplex)) {
            style |= 2;
        }
        if (Boolean.TRUE.equals(this.fontBoldComplex)) {
            style |= 1;
        }
        if (Boolean.TRUE.equals(this.fontUnderline)) {
            style |= 4;
        }
        if (Boolean.TRUE.equals(this.fontStrikeThru)) {
            style |= 8;
        }
        return style;
    }

    public boolean hasFontProperties() {
        return this.fontName != null || this.fontSize != -1.0f || this.fontItalic != null || this.fontBold != null || this.fontUnderline != null || this.fontStrikeThru != null || this.fontColor != null;
    }

    public boolean hasFontPropertiesAsian() {
        return this.fontNameAsian != null || this.fontSizeAsian != -1.0f || this.fontItalicAsian != null || this.fontBoldAsian != null || this.fontUnderline != null || this.fontStrikeThru != null || this.fontColor != null;
    }

    public boolean hasFontPropertiesComplex() {
        return this.fontNameComplex != null || this.fontSizeComplex != -1.0f || this.fontItalicComplex != null || this.fontBoldComplex != null || this.fontUnderline != null || this.fontStrikeThru != null || this.fontColor != null;
    }

    public Font getFont() {
        if (this.hasFontProperties()) {
            Float adjustedFontSize = Float.valueOf(this.fontSize);
            if (this.textPosition != null) {
                adjustedFontSize = Float.valueOf(adjustedFontSize.floatValue() * 0.63f);
            }
            return this.fontProvider.getFont(this.fontName, this.fontEncoding, adjustedFontSize.floatValue(), this.getStyleFlag(), this.fontColor);
        }
        return null;
    }

    public Font getFontAsian() {
        if (this.hasFontPropertiesAsian()) {
            Float adjustedFontSize = Float.valueOf(this.fontSizeAsian);
            if (this.textPosition != null) {
                adjustedFontSize = Float.valueOf(adjustedFontSize.floatValue() * 0.63f);
            }
            return this.fontProvider.getFont(this.fontNameAsian, this.fontEncoding, adjustedFontSize.floatValue(), this.getStyleFlagAsian(), this.fontColor);
        }
        return null;
    }

    public Font getFontComplex() {
        if (this.hasFontPropertiesComplex()) {
            Float adjustedFontSize = Float.valueOf(this.fontSizeComplex);
            if (this.textPosition != null) {
                adjustedFontSize = Float.valueOf(adjustedFontSize.floatValue() * 0.63f);
            }
            return this.fontProvider.getFont(this.fontNameComplex, this.fontEncoding, adjustedFontSize.floatValue(), this.getStyleFlagComplex(), this.fontColor);
        }
        return null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Boolean getFontBold() {
        return this.fontBold;
    }

    public void setFontBold(Boolean fontBold) {
        this.fontBold = fontBold;
    }

    public Boolean getFontBoldAsian() {
        return this.fontBoldAsian;
    }

    public void setFontBoldAsian(Boolean fontBoldAsian) {
        this.fontBoldAsian = fontBoldAsian;
    }

    public Boolean getFontBoldComplex() {
        return this.fontBoldComplex;
    }

    public void setFontBoldComplex(Boolean fontBoldComplex) {
        this.fontBoldComplex = fontBoldComplex;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public String getFontEncoding() {
        return this.fontEncoding;
    }

    public void setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
    }

    public Boolean getFontItalic() {
        return this.fontItalic;
    }

    public void setFontItalic(Boolean fontItalic) {
        this.fontItalic = fontItalic;
    }

    public Boolean getFontItalicAsian() {
        return this.fontItalicAsian;
    }

    public void setFontItalicAsian(Boolean fontItalicAsian) {
        this.fontItalicAsian = fontItalicAsian;
    }

    public Boolean getFontItalicComplex() {
        return this.fontItalicComplex;
    }

    public void setFontItalicComplex(Boolean fontItalicComplex) {
        this.fontItalicComplex = fontItalicComplex;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontNameAsian() {
        return this.fontNameAsian;
    }

    public void setFontNameAsian(String fontNameAsian) {
        this.fontNameAsian = fontNameAsian;
    }

    public String getFontNameComplex() {
        return this.fontNameComplex;
    }

    public void setFontNameComplex(String fontNameComplex) {
        this.fontNameComplex = fontNameComplex;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public float getFontSizeAsian() {
        return this.fontSizeAsian;
    }

    public void setFontSizeAsian(float fontSizeAsian) {
        this.fontSizeAsian = fontSizeAsian;
    }

    public float getFontSizeComplex() {
        return this.fontSizeComplex;
    }

    public void setFontSizeComplex(float fontSizeComplex) {
        this.fontSizeComplex = fontSizeComplex;
    }

    public Boolean getFontStrikeThru() {
        return this.fontStrikeThru;
    }

    public void setFontStrikeThru(Boolean fontStrikeThru) {
        this.fontStrikeThru = fontStrikeThru;
    }

    public Boolean getFontUnderline() {
        return this.fontUnderline;
    }

    public void setFontUnderline(Boolean fontUnderline) {
        this.fontUnderline = fontUnderline;
    }

    public Float getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(Float textPosition) {
        this.textPosition = textPosition;
    }
}

