/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core;

import fr.opensagres.poi.xwpf.converter.core.ListItemContext;
import java.util.HashMap;
import java.util.Map;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;

public class ListContext
extends ListItemContext {
    private final Map<Integer, ListItemContext> listItemByLevel = new HashMap<Integer, ListItemContext>();
    private int levelMax;

    public ListContext() {
        super(null, 0, null);
    }

    public ListItemContext addItem(CTLvl lvl) {
        int level = lvl.getIlvl().intValue();
        ListItemContext parent = this.getParent(level - 1);
        ListItemContext newItem = parent.createAndAddItem(lvl);
        for (int i = level; i <= this.levelMax; ++i) {
            this.listItemByLevel.remove(i);
        }
        this.listItemByLevel.put(level, newItem);
        if (level > this.levelMax) {
            this.levelMax = level;
        }
        return newItem;
    }

    private ListItemContext getParent(int level) {
        if (level < 0) {
            return this;
        }
        ListItemContext parent = null;
        for (int i = level; i >= 0; --i) {
            parent = this.listItemByLevel.get(level);
            if (parent == null) continue;
            return parent;
        }
        return this;
    }

    @Override
    public boolean isRoot() {
        return true;
    }
}

