/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core;

import fr.opensagres.poi.xwpf.converter.core.utils.RomanAlphabetFactory;
import fr.opensagres.poi.xwpf.converter.core.utils.RomanNumberFactory;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class ListItemContext {
    private int startIndex = 0;
    private int nb = 0;
    private final int number;
    private final CTLvl lvl;
    private final ListItemContext parent;
    private final String numberText;

    public ListItemContext(CTLvl lvl, int number, ListItemContext parent) {
        CTNumFmt numFmt;
        BigInteger val;
        CTDecimalNumber start;
        this.lvl = lvl;
        this.parent = parent;
        this.startIndex = 0;
        if (lvl != null && (start = lvl.getStart()) != null && (val = start.getVal()) != null) {
            this.startIndex = val.intValue();
        }
        this.nb = 0;
        this.number = number + this.startIndex;
        this.numberText = lvl != null ? ListItemContext.computeNumberText(this.number, (numFmt = lvl.getNumFmt()) != null ? numFmt.getVal() : null) : null;
    }

    public ListItemContext getParent() {
        return this.parent;
    }

    public CTLvl getLvl() {
        return this.lvl;
    }

    public int getNumber() {
        return this.number;
    }

    public String getNumberText() {
        return this.numberText;
    }

    private static String computeNumberText(int number, STNumberFormat.Enum numFmt) {
        if (STNumberFormat.LOWER_LETTER.equals(numFmt)) {
            return RomanAlphabetFactory.getLowerCaseString(number);
        }
        if (STNumberFormat.UPPER_LETTER.equals(numFmt)) {
            return RomanAlphabetFactory.getUpperCaseString(number);
        }
        if (STNumberFormat.LOWER_ROMAN.equals(numFmt)) {
            return RomanNumberFactory.getLowerCaseString(number);
        }
        if (STNumberFormat.UPPER_ROMAN.equals(numFmt)) {
            return RomanNumberFactory.getUpperCaseString(number);
        }
        return String.valueOf(number);
    }

    public ListItemContext createAndAddItem(CTLvl lvl) {
        return new ListItemContext(lvl, this.nb++, this);
    }

    public boolean isRoot() {
        return false;
    }

    public String getText() {
        String text = this.lvl.getLvlText().getVal();
        CTNumFmt numFmt = this.lvl.getNumFmt();
        if (!STNumberFormat.BULLET.equals(numFmt)) {
            ArrayList<String> numbers = new ArrayList<String>();
            ListItemContext item = this;
            while (!item.isRoot()) {
                numbers.add(0, item.getNumberText());
                item = item.getParent();
            }
            String number = null;
            for (int i = 0; i < numbers.size(); ++i) {
                number = (String)numbers.get(i);
                text = StringUtils.replaceAll(text, "%" + (i + 1), number);
            }
        }
        return text;
    }
}

