/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt;

import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import java.io.IOException;

public class ODTUtils {
    public static boolean isODT(XDocArchive documentArchive) {
        try {
            if (!documentArchive.hasEntry("mimetype")) {
                return false;
            }
            return "application/vnd.oasis.opendocument.text".equals(IOUtils.toString(documentArchive.getEntryReader("mimetype")));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isTable(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(uri) && "table".equals(localName);
    }

    public static boolean isTableRow(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(uri) && "table-row".equals(localName);
    }

    public static boolean isTextInput(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:text:1.0".equals(uri) && "text-input".equals(localName);
    }

    public static boolean isDrawFrame(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(uri) && "frame".equals(localName);
    }

    public static boolean isDrawImage(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(uri) && "image".equals(localName);
    }

    public static boolean isTextA(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:text:1.0".equals(uri) && "a".equals(localName);
    }

    public static boolean isAnnotation(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(uri) && "annotation".equals(localName);
    }

    public static boolean isAnnotationEnd(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(uri) && "annotation-end".equals(localName);
    }

    public static boolean isOfficeAutomaticStyles(String uri, String localName, String name) {
        return "urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(uri) && "automatic-styles".equals(localName);
    }
}

