/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity.internal;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.config.ReplaceText;
import fr.opensagres.xdocreport.template.velocity.VelocityConstants;
import java.util.Collection;
import org.apache.velocity.app.event.implement.EscapeXmlReference;
import org.apache.velocity.runtime.RuntimeServices;

public class XDocReportEscapeReference
extends EscapeXmlReference
implements VelocityConstants {
    private static final String NO_ESCAPE = "$___NoEscape";
    private static final String NO_ESCAPE_FCT = "${___NoEscape";
    private String[] searchList;
    private String[] replacementList;

    public void setRuntimeServices(RuntimeServices rs) {
        super.setRuntimeServices(rs);
        ITemplateEngine templateEngine = (ITemplateEngine)rs.getProperty("velocityTemplateEngine");
        Collection<ReplaceText> replacment = templateEngine.getConfiguration().getReplacment();
        if (replacment != null && replacment.size() > 0) {
            this.searchList = new String[replacment.size()];
            this.replacementList = new String[replacment.size()];
            int i = 0;
            for (ReplaceText replaceText : replacment) {
                this.searchList[i] = replaceText.getOldText();
                this.replacementList[i] = replaceText.getNewText();
                ++i;
            }
        }
    }

    protected String escape(Object text) {
        String result = super.escape(text);
        if (result != null && this.searchList != null) {
            result = StringUtils.replaceEach(result, this.searchList, this.replacementList);
        }
        return result;
    }

    public Object referenceInsert(String reference, Object value) {
        if (reference != null && (reference.startsWith(NO_ESCAPE) || reference.startsWith(NO_ESCAPE_FCT))) {
            return value;
        }
        return super.referenceInsert(reference, value);
    }
}

