/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.openxmlformats.styles.run;

import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;

public abstract class AbstractRunValueProvider<Value> {
    public Value getValue(CTR run, CTP paragraph, XWPFStylesDocument document) {
        CTDocDefaults docDefaults;
        CTPPr pPr;
        Value value = null;
        CTRPr rPr = run.getRPr();
        if (rPr != null) {
            value = this.getValue(rPr, document);
            if (value != null) {
                return value;
            }
            Value Value2 = value = rPr.sizeOfRStyleArray() > 0 ? (Value)this.getValueFromStyle(rPr.getRStyleArray(0), document) : null;
            if (value != null) {
                return value;
            }
            value = this.getValueFromStyle(document.getDefaultCharacterStyle(), document);
            if (value != null) {
                return value;
            }
        }
        if ((pPr = paragraph.getPPr()) != null) {
            value = this.getValue(pPr.getRPr(), document);
            if (value != null) {
                return value;
            }
            value = this.getValueFromStyle(pPr.getPStyle(), document);
            if (value != null) {
                return value;
            }
            value = this.getValueFromStyle(document.getDefaultParagraphStyle(), document);
            if (value != null) {
                return value;
            }
        }
        if ((docDefaults = document.getDocDefaults()) == null) {
            return null;
        }
        value = this.getValueFromDocDefaultsStyle(docDefaults, document);
        if (value != null) {
            return value;
        }
        return null;
    }

    private Value getValueFromStyle(CTString styleId, XWPFStylesDocument document) {
        CTStyle style = document.getStyle(styleId);
        return this.getValueFromStyle(style, document);
    }

    private Value getValueFromStyle(CTStyle style, XWPFStylesDocument document) {
        if (style != null) {
            Value value = this.getValue(style.getRPr(), document);
            if (value != null) {
                return value;
            }
            return this.getValueFromStyle(style.getBasedOn(), document);
        }
        return null;
    }

    private Value getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument document) {
        return this.getValue(this.getCTRPr(docDefaults), document);
    }

    public CTRPr getCTRPr(CTDocDefaults docDefaults) {
        CTRPrDefault prDefault = docDefaults.getRPrDefault();
        if (prDefault == null) {
            return null;
        }
        return prDefault.getRPr();
    }

    public abstract Value getValue(CTRPr var1, XWPFStylesDocument var2);

    public abstract Value getValue(CTParaRPr var1, XWPFStylesDocument var2);
}

