/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal.elements;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.poi.xwpf.converter.core.XWPFConverterException;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.IBoundsLimitContainer;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.IBreakHandlingContainer;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableColumnText;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StyleColumnProperties;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import java.util.ArrayList;
import java.util.List;

public class StylableDocumentSection {
    private IITextContainer parent;
    private IBoundsLimitContainer sectionParent;
    private IBreakHandlingContainer breakHandlingParent;
    private PdfPTable layoutTable;
    private boolean balanceText = true;
    private List<ColumnText> texts;
    private int colIdx;

    public StylableDocumentSection(StylableDocument ownerDocument, IITextContainer parent, boolean inHeaderFooter) {
        this.parent = parent;
        if (parent instanceof StylableDocumentSection) {
            StylableDocumentSection dc = (StylableDocumentSection)((Object)parent);
            dc.flushTable();
            this.sectionParent = dc.sectionParent;
        } else {
            this.sectionParent = (IBoundsLimitContainer)parent;
        }
        this.breakHandlingParent = StylableDocumentSection.getIBreakHandlingContainer(parent);
    }

    public IITextContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        this.layoutTable.calculateHeights(true);
        return this.layoutTable;
    }

    public void addElement(Element element) {
        if (element instanceof SectionPdfPTable) {
            this.sectionParent.addElement(element);
        } else {
            this.texts.get(this.colIdx).addElement(element);
            this.simulateText();
        }
    }

    public void columnBreak() {
        if (this.colIdx + 1 < this.layoutTable.getNumberOfColumns()) {
            this.setColIdx(this.colIdx + 1);
        } else {
            this.pageBreak();
        }
    }

    public void pageBreak() {
        if (this.breakHandlingParent != null) {
            if (this.sectionParent.getHeightLimit() >= 0.0f) {
                this.fillTable(this.sectionParent.getHeightLimit());
            }
            this.flushTable();
            this.breakHandlingParent.columnBreak();
        } else {
            this.setColIdx(this.colIdx + 1);
        }
    }

    private void flushTable() {
        this.sectionParent.addElement(this.getElement());
        this.layoutTable = StylableDocumentSection.cloneAndClearTable(this.layoutTable, true);
        this.texts = new ArrayList<ColumnText>();
        this.setColIdx(0);
    }

    private void simulateText() {
        float maxHeight = this.sectionParent.getHeightLimit();
        List<ColumnText> splittedTexts = this.fillTable(maxHeight);
        if (splittedTexts == null) {
            if (this.balanceText) {
                float minHeight = 0.0f;
                if (maxHeight < 0.0f) {
                    maxHeight = this.layoutTable.calculateHeights(true);
                }
                float currHeight = 0.0f;
                while (Math.abs(maxHeight - minHeight) > 0.1f) {
                    currHeight = (minHeight + maxHeight) / 2.0f;
                    if (this.fillTable(currHeight) == null) {
                        maxHeight = currHeight;
                        continue;
                    }
                    minHeight = currHeight;
                }
                if (currHeight != maxHeight) {
                    this.fillTable(maxHeight);
                }
            } else if (maxHeight >= 0.0f) {
                this.fillTable(-1.0f);
            }
        } else if (this.breakHandlingParent != null) {
            this.flushTable();
            this.breakHandlingParent.columnBreak();
            this.texts = splittedTexts;
            this.colIdx = this.texts.size() - 1;
            this.simulateText();
        }
    }

    private List<ColumnText> fillTable(float height) {
        StylableColumnText t;
        ArrayList<Object> tt = null;
        if (this.breakHandlingParent == null && this.colIdx >= this.layoutTable.getNumberOfColumns()) {
            tt = new ArrayList();
            t = StylableDocumentSection.createColumnText();
            tt.add((Object)t);
            for (int i = 0; i < this.texts.size(); ++i) {
                PdfPTable table = new PdfPTable(1);
                table.setWidthPercentage(100.0f);
                PdfPCell cell = new PdfPCell();
                cell.setBorder(0);
                cell.setPadding(0.0f);
                cell.setColumn(ColumnText.duplicate((ColumnText)this.texts.get(i)));
                table.addCell(cell);
                t.addElement((Element)table);
            }
        } else {
            tt = new ArrayList<ColumnText>(this.texts);
            for (int i = 0; i < tt.size(); ++i) {
                tt.set(i, ColumnText.duplicate((ColumnText)((ColumnText)tt.get(i))));
            }
        }
        StylableDocumentSection.clearTable(this.layoutTable, true);
        this.setWidthIfNecessary();
        t = (ColumnText)tt.get(0);
        for (PdfPCell cell : this.layoutTable.getRow(0).getCells()) {
            cell.setFixedHeight(height >= 0.0f ? height : -1.0f);
            cell.setColumn(ColumnText.duplicate((ColumnText)t));
            t.setSimpleColumn(cell.getLeft() + cell.getPaddingLeft(), height >= 0.0f ? -height : -1.0737418E9f, cell.getRight() - cell.getPaddingRight(), 0.0f);
            int res = 0;
            try {
                res = t.go(true);
            }
            catch (DocumentException e) {
                throw new XWPFConverterException(e);
            }
            if (ColumnText.hasMoreText((int)res)) continue;
            if (tt.size() == 1) {
                return null;
            }
            tt.remove(0);
            t = (ColumnText)tt.get(0);
        }
        return tt;
    }

    private void setColIdx(int idx) {
        this.colIdx = idx;
        for (int i = this.texts.size(); i <= idx; ++i) {
            StylableColumnText text = StylableDocumentSection.createColumnText();
            this.texts.add(text);
        }
    }

    private void setWidthIfNecessary() {
        if (this.layoutTable.getTotalWidth() != this.sectionParent.getWidthLimit()) {
            this.layoutTable.setTotalWidth(this.sectionParent.getWidthLimit());
        }
    }

    public static IBreakHandlingContainer getIBreakHandlingContainer(IITextContainer c) {
        return null;
    }

    public static SectionPdfPTable createLayoutTable(float width, float height) {
        ArrayList<StyleColumnProperties> columnPropertiesList = new ArrayList<StyleColumnProperties>();
        StyleColumnProperties columnProperties = new StyleColumnProperties();
        columnProperties.setRelWidth(100);
        columnPropertiesList.add(columnProperties);
        return StylableDocumentSection.createLayoutTable(width, height, columnPropertiesList);
    }

    public static SectionPdfPTable createLayoutTable(float width, float height, List<StyleColumnProperties> columnPropertiesList) {
        int colCount = columnPropertiesList.size();
        int[] relativeWidths = new int[colCount];
        SectionPdfPTable table = new SectionPdfPTable(colCount);
        for (int i = 0; i < colCount; ++i) {
            PdfPCell cell = new PdfPCell();
            cell.setBorder(0);
            cell.setPadding(0.0f);
            cell.setColumn((ColumnText)StylableDocumentSection.createColumnText());
            cell.setFixedHeight(height >= 0.0f ? height : -1.0f);
            StyleColumnProperties columnProperties = columnPropertiesList.get(i);
            relativeWidths[i] = columnProperties.getRelWidth();
            cell.setPaddingLeft(columnProperties.getStartIndent() != null ? columnProperties.getStartIndent().floatValue() : 0.0f);
            cell.setPaddingRight(columnProperties.getEndIndent() != null ? columnProperties.getEndIndent().floatValue() : 0.0f);
            table.addCell(cell);
        }
        StylableDocumentSection.replaceTableCells(table);
        try {
            table.setWidths(relativeWidths);
        }
        catch (DocumentException e) {
            throw new XWPFConverterException(e);
        }
        table.setTotalWidth(width);
        table.setLockedWidth(true);
        return table;
    }

    public static StylableColumnText createColumnText() {
        StylableColumnText text = new StylableColumnText();
        text.setAdjustFirstLine(false);
        return text;
    }

    public static void replaceTableCells(PdfPTable table) {
        PdfPCell[] cells = table.getRow(0).getCells();
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = new FixedHeightPdfPCell(cells[i]);
        }
    }

    public static PdfPCell getCell(PdfPTable table, int idx) {
        return table.getRow(0).getCells()[idx];
    }

    public static SectionPdfPTable cloneAndClearTable(PdfPTable table, boolean resetFixedHeight) {
        SectionPdfPTable clonedTable = new SectionPdfPTable(table);
        StylableDocumentSection.clearTable(clonedTable, resetFixedHeight);
        StylableDocumentSection.replaceTableCells(clonedTable);
        return clonedTable;
    }

    public static void clearTable(PdfPTable table, boolean resetFixedHeight) {
        for (PdfPCell cell : table.getRow(0).getCells()) {
            cell.setColumn((ColumnText)StylableDocumentSection.createColumnText());
            if (!resetFixedHeight) continue;
            cell.setFixedHeight(-1.0f);
        }
    }

    public IITextContainer getITextContainer() {
        return null;
    }

    public void setITextContainer(IITextContainer container) {
    }

    public static class SectionPdfPTable
    extends PdfPTable {
        public SectionPdfPTable(int numColumns) {
            super(numColumns);
        }

        public SectionPdfPTable(PdfPTable table) {
            super(table);
        }
    }

    public static class FixedHeightPdfPCell
    extends PdfPCell {
        public FixedHeightPdfPCell(PdfPCell cell) {
            super(cell);
        }

        public float getMaxHeight() {
            return this.getFixedHeight() >= 0.0f ? this.getFixedHeight() : super.getMaxHeight();
        }
    }
}

