/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.dom;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.utils.DOMUtils;
import fr.opensagres.xdocreport.core.utils.XPathUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.dom.DocxNamespaceContext;
import fr.opensagres.xdocreport.document.preprocessor.dom.DOMPreprocessor;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMFontsPreprocessor
extends DOMPreprocessor {
    public static final String FONT_NAME_KEY = "___fontName";
    public static final String FONT_SIZE_KEY = "___fontSize";
    public static final String FONT_SIZE_TWO_KEY = "___fontSizeTwo";
    public static final String FONT_SIZE_KEY_MULT_BY_2 = "___fontSize * 2";
    public static DOMFontsPreprocessor INSTANCE = new DOMFontsPreprocessor();

    @Override
    protected void visit(Document document, String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) throws XDocReportException {
        try {
            Element rFontsElt = null;
            NodeList rFontsNodeList = XPathUtils.evaluateNodeSet(document, "//w:rFonts", DocxNamespaceContext.INSTANCE);
            for (int i = 0; i < rFontsNodeList.getLength(); ++i) {
                Element szElt;
                rFontsElt = (Element)rFontsNodeList.item(i);
                if (i == 0) {
                    String set = formatter.getSetDirective(FONT_SIZE_TWO_KEY, FONT_SIZE_KEY_MULT_BY_2);
                    StringBuilder setWithIf = new StringBuilder();
                    setWithIf.append(formatter.getStartIfDirectiveIfExists(FONT_SIZE_KEY));
                    setWithIf.append(set);
                    setWithIf.append(formatter.getEndIfDirective(FONT_SIZE_KEY));
                    Node firstChild = rFontsElt.getOwnerDocument().getDocumentElement().getFirstChild();
                    Text newChild = rFontsElt.getOwnerDocument().createTextNode(setWithIf.toString());
                    rFontsElt.getOwnerDocument().getDocumentElement().insertBefore(newChild, firstChild);
                }
                this.updateDynamicAttr(rFontsElt, "w:ascii", FONT_NAME_KEY, formatter);
                this.updateDynamicAttr(rFontsElt, "w:cs", FONT_NAME_KEY, formatter);
                this.updateDynamicAttr(rFontsElt, "w:hAnsi", FONT_NAME_KEY, formatter);
                Element szCsElt = DOMUtils.getFirstChildElementByTagName(rFontsElt.getParentNode(), "w:szCs");
                if (szCsElt != null) {
                    this.updateDynamicAttr(szCsElt, "w:val", FONT_SIZE_KEY, formatter);
                }
                if ((szElt = DOMUtils.getFirstChildElementByTagName(rFontsElt.getParentNode(), "w:sz")) == null) continue;
                if (szCsElt != null) {
                    this.updateDynamicAttr(szElt, "w:val", FONT_SIZE_TWO_KEY, formatter);
                    continue;
                }
                this.updateDynamicAttr(szElt, "w:val", FONT_SIZE_KEY, formatter);
            }
        }
        catch (XPathExpressionException e) {
            throw new XDocReportException(e);
        }
    }
}

