/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.preprocessor;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ODTAnnotationParsingHelper {
    private static final String BEFORE_LABEL = "@before";
    private static final String AFTER_LABEL = "@after";
    private static final List<String> PARRENTS = Collections.unmodifiableList(Arrays.asList("table:table-row", "text:list-item", "text:section"));
    private boolean parsing = false;
    private StringBuilder content;
    private boolean ignore;
    private String replacement;
    private String after;
    private String before;
    private String name;
    private int index;
    private boolean notReplacedYet;

    public boolean isParsing() {
        return this.parsing;
    }

    public void setCurrentElement(String uri, String localName, String name) {
        if ("http://purl.org/dc/elements/1.1/".equals(uri)) {
            this.ignore = true;
            return;
        }
        this.ignore = false;
        if ("p".equals(localName) && this.content.length() > 0) {
            this.content.append('\n');
        }
    }

    public void setParsingBegin(String name, int index) {
        this.parsing = true;
        this.content = new StringBuilder();
        this.ignore = false;
        this.before = null;
        this.after = null;
        this.replacement = null;
        this.name = StringUtils.isNotEmpty(name) ? name : null;
        this.index = index;
        this.notReplacedYet = true;
    }

    public void setParsingEnd() {
        this.parse();
        this.parsing = false;
    }

    public boolean resetRangeAnnotation(String name, boolean force) {
        if (force || StringUtils.isNotEmpty(name) && name.equals(this.name)) {
            this.name = null;
            this.parsing = false;
            return true;
        }
        return false;
    }

    private void parse() {
        int indexBefore = this.content.indexOf(BEFORE_LABEL);
        int indexAfter = this.content.indexOf(AFTER_LABEL);
        if (indexBefore < 0 && indexAfter < 0) {
            if (this.content.length() > 0) {
                this.replacement = this.content.toString();
            }
        } else if (indexBefore < 0 || indexAfter < 0) {
            if (indexBefore > 0 || indexAfter > 0) {
                this.replacement = this.content.substring(0, Math.max(indexBefore, indexAfter));
            }
            if (indexBefore < 0) {
                this.after = this.content.substring(indexAfter + AFTER_LABEL.length(), this.content.length());
            } else {
                this.before = this.content.substring(indexBefore + BEFORE_LABEL.length(), this.content.length());
            }
        } else if (indexBefore < indexAfter) {
            if (indexBefore > 0) {
                this.replacement = this.content.substring(0, indexBefore);
            }
            this.before = this.content.substring(indexBefore + BEFORE_LABEL.length(), indexAfter);
            this.after = this.content.substring(indexAfter + AFTER_LABEL.length(), this.content.length());
        } else {
            if (indexAfter > 0) {
                this.replacement = this.content.substring(0, indexAfter);
            }
            this.after = this.content.substring(indexAfter + AFTER_LABEL.length(), indexBefore);
            this.before = this.content.substring(indexBefore + BEFORE_LABEL.length(), this.content.length());
        }
    }

    public void append(String value) {
        if (this.ignore) {
            return;
        }
        this.content.append(value);
    }

    public List<String> getParents() {
        return PARRENTS;
    }

    public boolean hasBefore() {
        return this.before != null;
    }

    public String getBefore() {
        return this.before;
    }

    public boolean hasAfter() {
        return this.after != null;
    }

    public String getAfter() {
        return this.after;
    }

    public boolean hasReplacement() {
        return this.replacement != null;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean isRangeAnnotation() {
        return this.name != null;
    }

    public boolean isTheSameBlock(int currentElementIndex) {
        return currentElementIndex >= this.index;
    }

    public boolean isNotReplacedYet() {
        return this.notReplacedYet;
    }

    public void setReplacementDone() {
        this.notReplacedYet = false;
    }
}

