/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.web;

import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.IURIResolver;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.OptionsHelper;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.ProcessState;
import fr.opensagres.xdocreport.document.dump.DumperOptions;
import fr.opensagres.xdocreport.document.dump.IDumper;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.document.web.BaseXDocReportServlet;
import fr.opensagres.xdocreport.document.web.WEBURIResolver;
import fr.opensagres.xdocreport.document.web.XDocProcessServletConstants;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class AbstractProcessXDocReportServlet
extends BaseXDocReportServlet
implements XDocProcessServletConstants {
    private static final String TEXT_HTML_CONTENT_TYPE = "text/html";
    private static final String WEB_URI_RESOLVER_DATA_KEY = WEBURIResolver.class.getName();
    private static final long serialVersionUID = -4228326301636062279L;
    private static final String ADMIN_JSP = "admin.jsp";
    private boolean cacheOriginalDocument = false;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.cacheOriginalDocument = StringUtils.asBoolean(super.getInitParameter("cacheOriginalDocument"), false);
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String dispatch = this.getDispatchParameter(request);
        if ("remove".equals(dispatch)) {
            this.doRemoveReport(request, response);
        } else {
            String entryName = this.getEntryName(request);
            ProcessState processState = super.getProcessState(request);
            if (processState == null) {
                processState = StringUtils.isNotEmpty(entryName) ? ProcessState.PREPROCESSED : ProcessState.GENERATED;
            }
            switch (processState) {
                case ORIGINAL: 
                case PREPROCESSED: {
                    this.doDocumentArchive(processState, entryName, request, response);
                    break;
                }
                case GENERATED: {
                    this.doGenerateReport(entryName, request, response);
                }
            }
        }
    }

    protected void doRemoveReport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String reportId = this.getReportId(request);
        if (StringUtils.isNotEmpty(reportId)) {
            this.getRegistry(request).unregisterReport(reportId);
        }
        this.doRedirectAfterRemoveReport(request, response);
    }

    protected void doRedirectAfterRemoveReport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(ADMIN_JSP);
    }

    protected void doDocumentArchive(ProcessState state, String entryName, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (StringUtils.isEmpty(entryName)) {
            this.doSaveReport(state, request, response);
        } else {
            this.doSaveEntry(state, entryName, request, response);
        }
    }

    protected void doSaveReport(ProcessState processState, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block4: {
            try {
                IXDocReport report = this.getReport(request);
                if (report == null) break block4;
                this.prepareHTTPResponse(report.getId(), report.getMimeMapping(), request, response);
                try {
                    report.save(processState, (OutputStream)response.getOutputStream());
                }
                catch (XDocReportException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (XDocReportException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doSaveEntry(ProcessState processState, String entryName, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block4: {
            try {
                IXDocReport report = this.getReport(request);
                if (report == null) break block4;
                try {
                    this.prepareHTTPResponse(report.getId(), entryName, request, response);
                    report.saveEntry(entryName, processState, (OutputStream)response.getOutputStream());
                }
                catch (XDocReportException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (XDocReportException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected boolean doGenerateReport(String entryName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IXDocReport report = null;
        IContext context = null;
        DumperOptions dumperOptions = null;
        try {
            report = this.getReport(request);
            if (report == null) {
                throw new XDocReportException("Cannot get XDoc Report for the HTTP request");
            }
            Options options = this.getOptionsConverter(report, request);
            dumperOptions = this.getOptionsDumper(report, request);
            if (options == null) {
                context = report.createContext();
                this.populateContext(context, report.getId(), request);
                this.doProcessReport(report, context, entryName, dumperOptions, request, response);
            } else {
                ITemplateEngine templateEngine = report.getTemplateEngine();
                if (templateEngine != null) {
                    context = report.createContext();
                    this.populateContext(context, report.getId(), request);
                }
                this.doProcessReportWithConverter(report, context, options, dumperOptions, request, response);
            }
            return true;
        }
        catch (Exception e) {
            this.error(report, context, dumperOptions, request, response, e);
            return false;
        }
    }

    private void doProcessReport(IXDocReport report, IContext context, String entryName, DumperOptions dumperOptions, HttpServletRequest request, HttpServletResponse response) throws XDocReportException, IOException {
        if (StringUtils.isEmpty(entryName)) {
            if (dumperOptions != null) {
                IDumper dumper = report.getDumper(dumperOptions);
                this.prepareHTTPResponse(report.getId(), dumper.getMimeMapping(), request, response);
                report.dump(context, dumperOptions, (OutputStream)response.getOutputStream());
            } else {
                this.prepareHTTPResponse(report.getId(), report.getMimeMapping(), request, response);
                report.process(context, (OutputStream)response.getOutputStream());
            }
        } else {
            this.prepareHTTPResponse(report.getId(), entryName, request, response);
            report.process(context, entryName, (OutputStream)response.getOutputStream());
        }
    }

    private void doProcessReportWithConverter(IXDocReport report, IContext context, Options options, DumperOptions dumperOptions, HttpServletRequest request, HttpServletResponse response) throws XDocReportException, IOException, XDocConverterException {
        if (dumperOptions != null) {
            IDumper dumper = report.getDumper(dumperOptions);
            this.prepareHTTPResponse(report.getId(), dumper.getMimeMapping(), request, response);
            report.dump(context, dumperOptions, (OutputStream)response.getOutputStream());
        } else {
            IConverter converter = report.getConverter(options);
            this.prepareHTTPResponse(report.getId(), converter.getMimeMapping(), request, response);
            report.convert(context, options, (OutputStream)response.getOutputStream());
        }
    }

    protected IXDocReport getReport(HttpServletRequest request) throws IOException, XDocReportException {
        IXDocReport report;
        XDocReportRegistry registry = this.getRegistry(request);
        String reportId = this.getReportId(request);
        if (StringUtils.isNotEmpty(reportId) && (report = registry.getReport(reportId)) != null) {
            return report;
        }
        return this.loadReport(reportId, registry, request);
    }

    protected IXDocReport loadReport(String reportId, XDocReportRegistry registry, HttpServletRequest request) throws IOException, XDocReportException {
        InputStream sourceStream = this.getSourceStream(reportId, request);
        if (sourceStream == null) {
            throw new XDocReportException("Input stream is null with reportId=" + reportId);
        }
        IXDocReport report = null;
        ITemplateEngine templateEngine = null;
        boolean cacheReport = this.isCacheReport(reportId, request);
        String templateEngineKind = this.getTemplateEngineKind(reportId, request);
        if (StringUtils.isNotEmpty(templateEngineKind)) {
            report = registry.loadReport(sourceStream, reportId, templateEngineKind, cacheReport);
        } else {
            templateEngine = this.getTemplateEngine(reportId, request);
            report = registry.loadReport(sourceStream, reportId, templateEngine, cacheReport);
        }
        FieldsMetadata fieldsMetadata = this.getFieldsMetadata(reportId, request);
        report.setFieldsMetadata(fieldsMetadata);
        report.setCacheOriginalDocument(this.isCacheOriginalDocument(reportId, request));
        return report;
    }

    protected boolean isCacheReport(String reportId, HttpServletRequest request) {
        return true;
    }

    protected boolean isCacheOriginalDocument(String reportId, HttpServletRequest request) {
        return this.cacheOriginalDocument;
    }

    protected FieldsMetadata getFieldsMetadata(String reportId, HttpServletRequest request) {
        return null;
    }

    protected void error(IXDocReport report, IContext context, DumperOptions dumperOptions, HttpServletRequest request, HttpServletResponse response, Exception cause) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new ServletException((Throwable)cause);
        }
        response.setContentType(TEXT_HTML_CONTENT_TYPE);
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append("<title>Error</title>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>XDocReport Servlet: Error report generation</h2>");
        html.append("<pre>");
        String why = cause.getMessage();
        if (why != null && why.trim().length() > 0) {
            html.append(why);
            html.append("<br>");
        }
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</pre>");
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }

    protected String getConverterId(IXDocReport report, HttpServletRequest request) {
        return request.getParameter("converter");
    }

    protected Options getOptionsConverter(IXDocReport report, HttpServletRequest request) {
        String converterId = this.getConverterId(report, request);
        if (StringUtils.isEmpty(converterId)) {
            return null;
        }
        Options options = null;
        int index = converterId.lastIndexOf(95);
        if (index != -1) {
            String to = converterId.substring(0, index);
            String via = converterId.substring(index + 1, converterId.length());
            options = Options.getTo(to).via(via);
        } else {
            options = Options.getTo(converterId);
        }
        this.prepareOptions(options, report, converterId, request);
        return options;
    }

    protected void prepareOptions(Options options, IXDocReport report, String converterId, HttpServletRequest request) {
        String fontEncoding;
        if (ConverterTypeTo.FO.name().equals(options.getTo()) || ConverterTypeTo.XHTML.name().equals(options.getTo())) {
            OptionsHelper.setURIResolver(options, this.createWEBURIResolver(report, converterId, request));
        }
        if (StringUtils.isNotEmpty(fontEncoding = this.getFontEncoding(report, converterId, request))) {
            OptionsHelper.setFontEncoding(options, fontEncoding);
        }
    }

    public IURIResolver createWEBURIResolver(IXDocReport report, String converterId, HttpServletRequest request) {
        WEBURIResolver resolver = (WEBURIResolver)report.getData(WEB_URI_RESOLVER_DATA_KEY);
        if (resolver == null) {
            resolver = new WEBURIResolver(report.getId(), request);
            report.setData(WEB_URI_RESOLVER_DATA_KEY, resolver);
        }
        return resolver;
    }

    protected DumperOptions getOptionsDumper(IXDocReport report, HttpServletRequest request) {
        String kind = this.getDumperKind(report, request);
        if (StringUtils.isEmpty(kind)) {
            return null;
        }
        DumperOptions options = new DumperOptions(kind);
        return options;
    }

    protected String getDumperKind(IXDocReport report, HttpServletRequest request) {
        return request.getParameter("dumper");
    }

    protected String getFontEncoding(IXDocReport report, String converterId, HttpServletRequest request) {
        return request.getParameter("fontEncoding");
    }

    @Override
    protected boolean isGenerateContentDisposition(String reportId, MimeMapping mimeMapping, HttpServletRequest request) {
        return !"view".equals(this.getDispatchParameter(request));
    }

    protected abstract InputStream getSourceStream(String var1, HttpServletRequest var2) throws IOException, XDocReportException;

    protected abstract void populateContext(IContext var1, String var2, HttpServletRequest var3) throws IOException, XDocReportException;
}

