/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.document.SyntaxKind;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldReplacementFormatter;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadataComparator;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadataXMLSerializer;
import fr.opensagres.xdocreport.template.formatter.FieldsNameComparator;
import fr.opensagres.xdocreport.template.formatter.ICustomFormatter;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import fr.opensagres.xdocreport.template.formatter.IFieldsMetadataClassSerializer;
import fr.opensagres.xdocreport.template.formatter.NullImageBehaviour;
import fr.opensagres.xdocreport.template.registry.FieldsMetadataClassSerializerRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldsMetadata {
    public static final FieldsMetadata EMPTY = new FieldsMetadata();
    public static final String DEFAULT_BEFORE_TABLE_TOKEN = "@before-table";
    public static final String DEFAULT_AFTER_TABLE_TOKEN = "@after-table";
    public static final String DEFAULT_BEFORE_ROW_TOKEN = "@before-row";
    public static final String DEFAULT_AFTER_ROW_TOKEN = "@after-row";
    public static final String DEFAULT_BEFORE_TABLE_CELL_TOKEN = "@before-cell";
    public static final String DEFAULT_AFTER_TABLE_CELL_TOKEN = "@after-cell";
    private IFieldsMetadataClassSerializer serializer;
    protected final List<FieldMetadata> fields = new ArrayList<FieldMetadata>();
    protected final Map<String, FieldMetadata> fieldsAsList = new HashMap<String, FieldMetadata>();
    protected final Map<String, FieldMetadata> fieldsAsImage = new HashMap<String, FieldMetadata>();
    protected final Map<String, FieldMetadata> fieldsAsTextStyling = new HashMap<String, FieldMetadata>();
    private String beforeTableToken = "@before-table";
    private String afterTableToken = "@after-table";
    private String beforeRowToken = "@before-row";
    private String afterRowToken = "@after-row";
    private String beforeTableCellToken = "@before-cell";
    private String afterTableCellToken = "@after-cell";
    private String description;
    private String templateEngineKind;
    private boolean evaluateEngineOnlyForFields;
    private NullImageBehaviour behaviour;
    private boolean useImageSize;
    private List<String> sortedFieldsAsList;
    private List<FieldMetadata> sortedFieldsAsTextStyling;
    private List<FieldMetadata> sortedFieldsAsImage;
    private List<ICustomFormatter> customFormatters;

    public FieldsMetadata() {
        this((String)null);
    }

    public FieldsMetadata(TemplateEngineKind templateEngineKind) {
        this(templateEngineKind.name());
    }

    public FieldsMetadata(String templateEngineKind) {
        this.setTemplateEngineKind(templateEngineKind);
        this.evaluateEngineOnlyForFields = false;
        this.behaviour = null;
        this.useImageSize = false;
        this.sortedFieldsAsList = null;
        this.sortedFieldsAsTextStyling = null;
        this.sortedFieldsAsImage = null;
        this.customFormatters = null;
    }

    public FieldMetadata addFieldAsImage(String fieldName) {
        return this.addFieldAsImage(fieldName, this.isUseImageSize());
    }

    public FieldMetadata addFieldAsImage(String fieldName, boolean useImageSize) {
        return this.addFieldAsImage(fieldName, fieldName, null, useImageSize);
    }

    public FieldMetadata addFieldAsImage(String fieldName, NullImageBehaviour behaviour) {
        return this.addFieldAsImage(fieldName, fieldName, behaviour, this.isUseImageSize());
    }

    public FieldMetadata addFieldAsImage(String fieldName, NullImageBehaviour behaviour, boolean useImageSize) {
        return this.addFieldAsImage(fieldName, fieldName, behaviour, useImageSize);
    }

    public FieldMetadata addFieldAsImage(String imageName, String fieldName) {
        return this.addFieldAsImage(imageName, fieldName, this.isUseImageSize());
    }

    public FieldMetadata addFieldAsImage(String imageName, String fieldName, boolean useImageSize) {
        return this.addFieldAsImage(imageName, fieldName, null, useImageSize);
    }

    public FieldMetadata addFieldAsImage(String imageName, String fieldName, NullImageBehaviour behaviour) {
        return this.addFieldAsImage(imageName, fieldName, behaviour, this.isUseImageSize());
    }

    public FieldMetadata addFieldAsImage(String imageName, String fieldName, NullImageBehaviour behaviour, boolean useImageSize) {
        FieldMetadata field = this.addField(fieldName, null, imageName, null, null);
        field.setBehaviour(behaviour);
        field.setUseImageSize(useImageSize);
        return field;
    }

    public FieldMetadata addFieldAsTextStyling(String fieldName, SyntaxKind syntaxKind) {
        return this.addFieldAsTextStyling(fieldName, syntaxKind, false);
    }

    public FieldMetadata addFieldAsTextStyling(String fieldName, SyntaxKind syntaxKind, boolean syntaxWithDirective) {
        return this.addFieldAsTextStyling(fieldName, syntaxKind.name(), syntaxWithDirective);
    }

    public FieldMetadata addFieldAsTextStyling(String fieldName, String syntaxKind) {
        return this.addFieldAsTextStyling(fieldName, syntaxKind, false);
    }

    public FieldMetadata addFieldAsTextStyling(String fieldName, String syntaxKind, boolean syntaxWithDirective) {
        return this.addField(fieldName, null, null, syntaxKind, syntaxWithDirective);
    }

    public FieldMetadata addFieldAsList(String fieldName) {
        return this.addField(fieldName, true, null, null, null);
    }

    public FieldMetadata addField(String fieldName, Boolean listType, String imageName, String syntaxKind, Boolean syntaxWithDirective) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Argument 'fieldName' can not be null");
        }
        FieldMetadata exsitingField = this.getFieldAsImage(fieldName);
        if (exsitingField == null) {
            exsitingField = this.fieldsAsList.get(fieldName);
        }
        if (exsitingField == null) {
            exsitingField = this.fieldsAsTextStyling.get(fieldName);
        }
        if (exsitingField == null) {
            FieldMetadata fieldMetadata = new FieldMetadata(this, fieldName, listType == null ? false : listType, imageName, syntaxKind, syntaxWithDirective == null ? false : syntaxWithDirective);
            return fieldMetadata;
        }
        if (listType != null) {
            exsitingField.setListType(listType);
        }
        if (StringUtils.isNotEmpty(imageName)) {
            exsitingField.setImageName(imageName);
        }
        if (StringUtils.isNotEmpty(syntaxKind)) {
            exsitingField.setSyntaxKind(syntaxKind);
        }
        if (syntaxWithDirective != null) {
            exsitingField.setSyntaxWithDirective(syntaxWithDirective);
        }
        return exsitingField;
    }

    public FieldMetadata getFieldAsImage(String fieldName) {
        return this.fieldsAsImage.get(fieldName);
    }

    public Collection<String> getFieldsAsList() {
        if (this.sortedFieldsAsList == null) {
            this.sortedFieldsAsList = new ArrayList<String>();
            for (FieldMetadata field : this.fieldsAsList.values()) {
                this.sortedFieldsAsList.add(field.getFieldName());
            }
            Collections.sort(this.sortedFieldsAsList, FieldsNameComparator.getInstance());
        }
        return this.sortedFieldsAsList;
    }

    public Collection<FieldMetadata> getFieldsAsImage() {
        if (this.sortedFieldsAsImage == null) {
            this.sortedFieldsAsImage = new ArrayList<FieldMetadata>(this.fieldsAsImage.values());
            Collections.sort(this.sortedFieldsAsImage, FieldsMetadataComparator.getInstance());
        }
        return this.sortedFieldsAsImage;
    }

    public Collection<FieldMetadata> getFieldsAsTextStyling() {
        if (this.sortedFieldsAsTextStyling == null) {
            this.sortedFieldsAsTextStyling = new ArrayList<FieldMetadata>(this.fieldsAsTextStyling.values());
            Collections.sort(this.sortedFieldsAsTextStyling, FieldsMetadataComparator.getInstance());
        }
        return this.sortedFieldsAsTextStyling;
    }

    public FieldMetadata getFieldAsTextStyling(String content) {
        Collection<FieldMetadata> fieldsAsTextStyling = this.getFieldsAsTextStyling();
        for (FieldMetadata field : fieldsAsTextStyling) {
            if (!content.contains(field.getFieldName())) continue;
            return field;
        }
        return null;
    }

    public boolean hasFieldsAsImage() {
        return this.fieldsAsImage.size() > 0;
    }

    public boolean isFieldAsImage(String fieldName) {
        if (StringUtils.isEmpty(fieldName)) {
            return false;
        }
        return this.fieldsAsImage.containsKey(fieldName);
    }

    public String getImageFieldName(String fieldName) {
        if (StringUtils.isEmpty(fieldName)) {
            return null;
        }
        FieldMetadata metadata = this.getFieldAsImage(fieldName);
        if (metadata != null) {
            return metadata.getFieldName();
        }
        return null;
    }

    public String getBeforeTableToken() {
        return this.beforeTableToken;
    }

    public void setBeforeTableToken(String beforeTableToken) {
        this.beforeTableToken = beforeTableToken;
    }

    public String getAfterTableToken() {
        return this.afterTableToken;
    }

    public void setAfterTableToken(String afterTableToken) {
        this.afterTableToken = afterTableToken;
    }

    public String getBeforeRowToken() {
        return this.beforeRowToken;
    }

    public void setBeforeRowToken(String beforeRowToken) {
        this.beforeRowToken = beforeRowToken;
    }

    public String getAfterRowToken() {
        return this.afterRowToken;
    }

    public void setAfterRowToken(String afterRowToken) {
        this.afterRowToken = afterRowToken;
    }

    public String getBeforeTableCellToken() {
        return this.beforeTableCellToken;
    }

    public void setBeforeTableCellToken(String beforeTableCellToken) {
        this.beforeTableCellToken = beforeTableCellToken;
    }

    public String getAfterTableCellToken() {
        return this.afterTableCellToken;
    }

    public void setAfterTableCellToken(String afterTableCellToken) {
        this.afterTableCellToken = afterTableCellToken;
    }

    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    public void saveXML(Writer writer) throws IOException {
        this.saveXML(writer, false);
    }

    public void saveXML(Writer writer, boolean indent) throws IOException {
        FieldsMetadataXMLSerializer.getInstance().save(this, writer, indent, false);
    }

    public void saveXML(Writer writer, boolean indent, boolean formatAsJavaString) throws IOException {
        FieldsMetadataXMLSerializer.getInstance().save(this, writer, indent, formatAsJavaString);
    }

    public void saveXML(OutputStream out) throws IOException {
        this.saveXML(out, false);
    }

    public void saveXML(OutputStream out, boolean indent) throws IOException {
        FieldsMetadataXMLSerializer.getInstance().save(this, out, indent, false);
    }

    public void load(String key, Class<?> clazz) throws XDocReportException {
        this.load(key, clazz, false);
    }

    public void load(String key, Class<?> clazz, boolean listType) throws XDocReportException {
        if (this.serializer == null) {
            throw new XDocReportException("Cannot find serializer. Please set the template engine FieldsMetadata#setTemplateEngineKind(String templateEngineKind) before calling this method.");
        }
        this.serializer.load(this, key, clazz, listType);
    }

    public String toString() {
        StringWriter xml = new StringWriter();
        try {
            this.saveXML(xml, true);
        }
        catch (IOException e) {
            return super.toString();
        }
        return xml.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTemplateEngineKind() {
        return this.templateEngineKind;
    }

    public void setTemplateEngineKind(String templateEngineKind) {
        this.templateEngineKind = templateEngineKind;
        this.serializer = templateEngineKind == null ? null : FieldsMetadataClassSerializerRegistry.getRegistry().getSerializer(templateEngineKind);
    }

    public boolean isEvaluateEngineOnlyForFields() {
        return this.evaluateEngineOnlyForFields;
    }

    public void setEvaluateEngineOnlyForFields(boolean evaluateEngineOnlyForFields) {
        this.evaluateEngineOnlyForFields = evaluateEngineOnlyForFields;
    }

    public NullImageBehaviour getBehaviour() {
        return this.behaviour;
    }

    public void setBehaviour(NullImageBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public boolean isUseImageSize() {
        return this.useImageSize;
    }

    public void setUseImageSize(boolean useImageSize) {
        this.useImageSize = useImageSize;
    }

    public void addCustomFormatter(ICustomFormatter customFormatter) {
        if (this.customFormatters == null) {
            this.customFormatters = new ArrayList<ICustomFormatter>();
        }
        this.customFormatters.add(customFormatter);
    }

    public List<ICustomFormatter> getCustomFormatter() {
        return this.customFormatters;
    }

    public void addFieldReplacement(String search, String replacement) {
        FieldReplacementFormatter mappingFormatter = this.getFieldReplacementFormatter();
        if (mappingFormatter == null) {
            mappingFormatter = new FieldReplacementFormatter();
            this.addCustomFormatter(mappingFormatter);
        }
        mappingFormatter.addMapping(search, replacement);
    }

    private FieldReplacementFormatter getFieldReplacementFormatter() {
        if (this.customFormatters == null) {
            return null;
        }
        for (ICustomFormatter customFormatter : this.customFormatters) {
            if (!(customFormatter instanceof FieldReplacementFormatter)) continue;
            return (FieldReplacementFormatter)customFormatter;
        }
        return null;
    }

    public String customFormat(String content, IDocumentFormatter formatter) {
        if (this.customFormatters == null) {
            return content;
        }
        String newContent = null;
        for (ICustomFormatter customFormatter : this.customFormatters) {
            newContent = customFormatter.format(content, formatter);
            if (newContent == null) continue;
            return newContent;
        }
        return newContent != null ? newContent : content;
    }
}

