/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.freemarker;

import fr.opensagres.xdocreport.core.EncodingConstants;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.template.AbstractTemplateEngine;
import fr.opensagres.xdocreport.template.FieldsExtractor;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.config.ITemplateEngineConfiguration;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import fr.opensagres.xdocreport.template.freemarker.FreemarkerConstants;
import fr.opensagres.xdocreport.template.freemarker.FreemarkerDocumentFormatter;
import fr.opensagres.xdocreport.template.freemarker.cache.XDocReportEntryTemplateLoader;
import fr.opensagres.xdocreport.template.freemarker.internal.XDocFreemarkerContext;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine
implements FreemarkerConstants {
    private static final String DOLLAR_VARIABLE = "DollarVariable";
    private static Configuration DEFAULT_FREEMARKER_CONFIGURATION = null;
    private FreemarkerDocumentFormatter formatter = new FreemarkerDocumentFormatter();
    private Configuration freemarkerConfiguration = null;
    private boolean forceModifyReader = false;
    private final List<TemplateLoader> templateLoaders = new ArrayList<TemplateLoader>();

    public FreemarkerTemplateEngine() {
        this.templateLoaders.add(new XDocReportEntryTemplateLoader(this));
    }

    @Override
    public String getKind() {
        return TemplateEngineKind.Freemarker.name();
    }

    @Override
    public String getId() {
        return "Freemarker_2.3.x";
    }

    @Override
    public IContext createContext() {
        return new XDocFreemarkerContext();
    }

    @Override
    public IContext createContext(Map<String, Object> contextMap) {
        return new XDocFreemarkerContext(contextMap);
    }

    @Override
    protected void processWithCache(String templateName, IContext context, Writer writer) throws XDocReportException, IOException {
        Template template = this.getFreemarkerConfiguration().getTemplate(templateName);
        this.process(context, writer, template);
    }

    @Override
    protected void processNoCache(String templateName, IContext context, Reader reader, Writer writer) throws XDocReportException, IOException {
        Template template = new Template(templateName, this.getReader(reader), this.getFreemarkerConfiguration());
        this.process(context, writer, template);
    }

    private Reader getReader(Reader reader) throws IOException {
        if (this.forceModifyReader && this.isEscapeTemplate()) {
            StringBuilder newTemplate = new StringBuilder(this.formatter.getStartDocumentDirective());
            String oldTemplate = IOUtils.toString(reader);
            newTemplate.append(oldTemplate);
            newTemplate.append(this.formatter.getEndDocumentDirective());
            return new StringReader(newTemplate.toString());
        }
        return reader;
    }

    private void process(IContext context, Writer writer, Template template) throws IOException, XDocReportException {
        try {
            Environment environment = template.createProcessingEnvironment((Object)context, writer);
            environment.process();
        }
        catch (TemplateException e) {
            throw new XDocReportException(e);
        }
    }

    public Configuration getFreemarkerConfiguration() {
        if (this.freemarkerConfiguration == null) {
            return this.getDefaultConfiguration();
        }
        return this.freemarkerConfiguration;
    }

    public void setFreemarkerConfiguration(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
        this.freemarkerConfiguration.setTagSyntax(2);
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(this.templateLoaders.toArray(new TemplateLoader[0])));
        try {
            this.freemarkerConfiguration.setSetting("template_update_delay", "0");
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        this.freemarkerConfiguration.setLocalizedLookup(false);
    }

    @Override
    public void extractFields(Reader reader, String entryName, FieldsExtractor extractor) throws XDocReportException {
        try {
            Template template = new Template(entryName, reader, this.getFreemarkerConfiguration());
            TemplateElement templateElement = template.getRootTreeNode();
            this.extractVariables(templateElement, extractor);
            templateElement.getChildNodes();
        }
        catch (IOException e) {
            throw new XDocReportException(e);
        }
        catch (TemplateModelException e) {
            throw new XDocReportException(e);
        }
    }

    private void extractVariables(TemplateElement templateElement, FieldsExtractor extractor) throws TemplateModelException {
        if (DOLLAR_VARIABLE.equals(templateElement.getClass().getSimpleName())) {
            String fieldName = templateElement.getCanonicalForm();
            fieldName = fieldName.substring(2, fieldName.length() - 1);
            extractor.addFieldName(fieldName, false);
        }
        Enumeration enums = templateElement.children();
        while (enums.hasMoreElements()) {
            TemplateElement element = (TemplateElement)enums.nextElement();
            this.extractVariables(element, extractor);
        }
    }

    @Override
    public IDocumentFormatter getDocumentFormatter() {
        return this.formatter;
    }

    private Configuration getDefaultConfiguration() {
        if (DEFAULT_FREEMARKER_CONFIGURATION == null) {
            DEFAULT_FREEMARKER_CONFIGURATION = new Configuration();
            DEFAULT_FREEMARKER_CONFIGURATION.setDefaultEncoding(EncodingConstants.UTF_8.name());
            DEFAULT_FREEMARKER_CONFIGURATION.setOutputEncoding(EncodingConstants.UTF_8.name());
            DEFAULT_FREEMARKER_CONFIGURATION.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            this.setFreemarkerConfiguration(DEFAULT_FREEMARKER_CONFIGURATION);
        }
        return DEFAULT_FREEMARKER_CONFIGURATION;
    }

    @Override
    public void setConfiguration(ITemplateEngineConfiguration configuration) {
        super.setConfiguration(configuration);
        if (this.isEscapeTemplate()) {
            this.formatter.setConfiguration(configuration);
        }
    }

    private boolean isEscapeTemplate() {
        return this.getConfiguration() != null && (this.getConfiguration().escapeXML() || this.getConfiguration().getReplacment() != null && this.getConfiguration().getReplacment().size() > 0);
    }

    public void setForceModifyReader(boolean forceModifyReader) {
        this.forceModifyReader = forceModifyReader;
    }

    public boolean isForceModifyReader() {
        return this.forceModifyReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String templateName, IContext context, Writer writer) throws IOException, XDocReportException {
        templateName = (String)templateName + ".ftl";
        InputStreamReader reader = new InputStreamReader(FreemarkerTemplateEngine.class.getResourceAsStream((String)templateName));
        try {
            Template template = new Template((String)templateName, (Reader)reader, this.getFreemarkerConfiguration());
            this.process(context, writer, template);
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
        }
    }

    @Override
    public boolean isFieldNameStartsWithUpperCase() {
        return true;
    }

    public void addTemplateLoader(TemplateLoader loader) {
        this.templateLoaders.add(loader);
    }
}

