/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.spring.elasticsearch.ElasticsearchAbstractClientFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ElasticsearchTransportClientFactoryBean
extends ElasticsearchAbstractClientFactoryBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String[] esNodes = new String[]{"localhost:9300"};

    public String[] getEsNodes() {
        return this.esNodes;
    }

    public void setEsNodes(String[] esNodes) {
        this.esNodes = esNodes;
    }

    @Override
    protected Client buildClient() throws Exception {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder();
        if (null != this.settings && null == this.properties) {
            builder.put(this.settings);
        }
        if (null != this.settingsFile && null == this.properties) {
            this.logger.warn((Object)"settings has been deprecated in favor of properties. See issue #15: https://github.com/dadoonet/spring-elasticsearch/issues/15.");
            builder.loadFromClasspath(this.settingsFile);
        }
        if (null != this.properties) {
            builder.put(this.properties);
        }
        TransportClient client = new TransportClient(builder.build());
        for (int i = 0; i < this.esNodes.length; ++i) {
            client.addTransportAddress((TransportAddress)this.toAddress(this.esNodes[i]));
        }
        return client;
    }

    private InetSocketTransportAddress toAddress(String address) {
        if (address == null) {
            return null;
        }
        String[] splitted = address.split(":");
        int port = 9300;
        if (splitted.length > 1) {
            port = Integer.parseInt(splitted[1]);
        }
        return new InetSocketTransportAddress(splitted[0], port);
    }
}

