/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.servlet.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiresFilter
implements Filter {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final Logger logger = LoggerFactory.getLogger(ExpiresFilter.class);
    private static final String PARAMETER_EXPIRES_ACTIVE = "ExpiresActive";
    private static final String PARAMETER_EXPIRES_BY_TYPE = "ExpiresByType";
    private static final String PARAMETER_EXPIRES_DEFAULT = "ExpiresDefault";
    private static final String PARAMETER_EXPIRES_EXCLUDED_RESPONSE_STATUS_CODES = "ExpiresExcludedResponseStatusCodes";
    private boolean active = true;
    private ExpiresConfiguration defaultExpiresConfiguration;
    private int[] excludedResponseStatusCodes = new int[]{304};
    private Map<String, ExpiresConfiguration> expiresConfigurationByContentType = new LinkedHashMap<String, ExpiresConfiguration>();

    protected static int[] commaDelimitedListToIntArray(String commaDelimitedInts) {
        String[] intsAsStrings = ExpiresFilter.commaDelimitedListToStringArray(commaDelimitedInts);
        int[] ints = new int[intsAsStrings.length];
        for (int i = 0; i < intsAsStrings.length; ++i) {
            String intAsString = intsAsStrings[i];
            try {
                ints[i] = Integer.parseInt(intAsString);
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Exception parsing number '" + i + "' (zero based) of comma delimited list '" + commaDelimitedInts + "'");
            }
        }
        return ints;
    }

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    protected static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    protected static String intsToCommaDelimitedString(int[] ints) {
        if (ints == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < ints.length; ++i) {
            result.append(ints[i]);
            if (i >= ints.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected static boolean isNotEmpty(String str) {
        return !ExpiresFilter.isEmpty(str);
    }

    protected static boolean startsWithIgnoreCase(String string, String prefix) {
        if (string == null || prefix == null) {
            return string == null && prefix == null;
        }
        if (prefix.length() > string.length()) {
            return false;
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    protected static String substringBefore(String str, String separator) {
        if (ExpiresFilter.isEmpty(str) || separator == null) {
            return null;
        }
        if (separator.length() == 0) {
            return "";
        }
        int separatorIndex = str.indexOf(separator);
        if (separatorIndex == -1) {
            return str;
        }
        return str.substring(0, separatorIndex);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (response.isCommitted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Request '" + httpRequest.getRequestURL() + "', can not apply ExpiresFilter on already committed response.");
                }
                chain.doFilter(request, response);
            } else if (this.active) {
                XHttpServletResponse xResponse = new XHttpServletResponse(httpRequest, httpResponse);
                chain.doFilter(request, (ServletResponse)xResponse);
                if (!xResponse.isWriteResponseBodyStarted()) {
                    this.onBeforeWriteResponseBody(httpRequest, xResponse);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Request '" + httpRequest.getRequestURL() + "', ExpiresFilter is NOT active");
                }
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public ExpiresConfiguration getDefaultExpiresConfiguration() {
        return this.defaultExpiresConfiguration;
    }

    public String getExcludedResponseStatusCodes() {
        return ExpiresFilter.intsToCommaDelimitedString(this.excludedResponseStatusCodes);
    }

    public int[] getExcludedResponseStatusCodesAsInts() {
        return this.excludedResponseStatusCodes;
    }

    protected Date getExpirationDate(HttpServletRequest request, XHttpServletResponse response) {
        Calendar calendar;
        String contentType = response.getContentType();
        ExpiresConfiguration configuration = this.expiresConfigurationByContentType.get(contentType);
        String matchingContentType = contentType;
        if (configuration == null && ExpiresFilter.contains(contentType, ";")) {
            String contentTypeWithoutCharset = ExpiresFilter.substringBefore(contentType, ";").trim();
            configuration = this.expiresConfigurationByContentType.get(contentTypeWithoutCharset);
            matchingContentType = contentTypeWithoutCharset;
        }
        if (configuration == null && ExpiresFilter.contains(contentType, "/")) {
            String majorType = ExpiresFilter.substringBefore(contentType, "/");
            configuration = this.expiresConfigurationByContentType.get(majorType);
            matchingContentType = majorType;
        }
        if (configuration == null) {
            configuration = this.defaultExpiresConfiguration;
            matchingContentType = "#DEFAULT#";
        }
        if (configuration == null) {
            logger.trace("No Expires configuration found for content-type {}", (Object)contentType);
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Use {} matching '{}' for content-type '{}'", new Object[]{configuration, matchingContentType, contentType});
        }
        switch (configuration.getStartingPoint()) {
            case ACCESS_TIME: {
                calendar = GregorianCalendar.getInstance();
                break;
            }
            case LAST_MODIFICATION_TIME: {
                if (response.isLastModifiedHeaderSet()) {
                    long lastModified = response.getLastModifiedHeader();
                    calendar = GregorianCalendar.getInstance();
                    calendar.setTimeInMillis(lastModified);
                    break;
                }
                calendar = GregorianCalendar.getInstance();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported startingPoint '" + (Object)((Object)configuration.getStartingPoint()) + "'");
            }
        }
        for (Duration duration : configuration.getDurations()) {
            calendar.add(duration.getUnit().getCalendardField(), duration.getAmount());
        }
        return calendar.getTime();
    }

    public Map<String, ExpiresConfiguration> getExpiresConfigurationByContentType() {
        return this.expiresConfigurationByContentType;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = filterConfig.getInitParameter(name);
            try {
                if (name.startsWith(PARAMETER_EXPIRES_BY_TYPE)) {
                    String contentType = name.substring(PARAMETER_EXPIRES_BY_TYPE.length()).trim();
                    ExpiresConfiguration expiresConfiguration = this.parseExpiresConfiguration(value);
                    this.expiresConfigurationByContentType.put(contentType, expiresConfiguration);
                    continue;
                }
                if (name.equalsIgnoreCase(PARAMETER_EXPIRES_DEFAULT)) {
                    ExpiresConfiguration expiresConfiguration;
                    this.defaultExpiresConfiguration = expiresConfiguration = this.parseExpiresConfiguration(value);
                    continue;
                }
                if (name.equalsIgnoreCase(PARAMETER_EXPIRES_ACTIVE)) {
                    this.active = "On".equalsIgnoreCase(value) || Boolean.valueOf(value) != false;
                    continue;
                }
                if (name.equalsIgnoreCase(PARAMETER_EXPIRES_EXCLUDED_RESPONSE_STATUS_CODES)) {
                    this.excludedResponseStatusCodes = ExpiresFilter.commaDelimitedListToIntArray(value);
                    continue;
                }
                logger.warn("Uknown parameter '" + name + "' with value '" + value + "' is ignored !");
            }
            catch (RuntimeException e) {
                throw new ServletException("Exception processing configuration parameter '" + name + "':'" + value + "'", (Throwable)e);
            }
        }
        logger.info("Filter initialized with configuration " + this.toString());
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isEligibleToExpirationHeaderGeneration(HttpServletRequest request, XHttpServletResponse response) {
        boolean expirationHeaderHasBeenSet;
        boolean bl = expirationHeaderHasBeenSet = response.containsHeader(HEADER_EXPIRES) || ExpiresFilter.contains(response.getCacheControlHeader(), "max-age");
        if (expirationHeaderHasBeenSet) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request '{}' with response status '{}' content-type '{}', expiration header already defined", new Object[]{request.getRequestURI(), response.getStatus(), response.getContentType()});
            }
            return false;
        }
        for (int skippedStatusCode : this.excludedResponseStatusCodes) {
            if (response.getStatus() != skippedStatusCode) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Request '{}' with response status '{}' content-type '{}', skip expiration header generation for given status", new Object[]{request.getRequestURI(), response.getStatus(), response.getContentType()});
            }
            return false;
        }
        return true;
    }

    public void onBeforeWriteResponseBody(HttpServletRequest request, XHttpServletResponse response) {
        if (!this.isEligibleToExpirationHeaderGeneration(request, response)) {
            return;
        }
        Date expirationDate = this.getExpirationDate(request, response);
        if (expirationDate == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request '{}' with response status '{}' content-type '{}', no expiration configured", new Object[]{request.getRequestURI(), response.getStatus(), response.getContentType()});
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Request '{}' with response status '{}' content-type '{}', set expiration date {}", new Object[]{request.getRequestURI(), response.getStatus(), response.getContentType(), expirationDate});
            }
            String maxAgeDirective = "max-age=" + (expirationDate.getTime() - System.currentTimeMillis()) / 1000L;
            String cacheControlHeader = response.getCacheControlHeader();
            String newCacheControlHeader = cacheControlHeader == null ? maxAgeDirective : cacheControlHeader + ", " + maxAgeDirective;
            response.setHeader(HEADER_CACHE_CONTROL, newCacheControlHeader);
            response.setDateHeader(HEADER_EXPIRES, expirationDate.getTime());
        }
    }

    protected ExpiresConfiguration parseExpiresConfiguration(String line) {
        StartingPoint startingPoint;
        String currentToken;
        line = line.trim();
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        try {
            currentToken = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Starting point (access|now|modification|a<seconds>|m<seconds>) not found in directive '" + line + "'");
        }
        if ("access".equalsIgnoreCase(currentToken) || "now".equalsIgnoreCase(currentToken)) {
            startingPoint = StartingPoint.ACCESS_TIME;
        } else if ("modification".equalsIgnoreCase(currentToken)) {
            startingPoint = StartingPoint.LAST_MODIFICATION_TIME;
        } else if (!tokenizer.hasMoreTokens() && ExpiresFilter.startsWithIgnoreCase(currentToken, "a")) {
            startingPoint = StartingPoint.ACCESS_TIME;
            tokenizer = new StringTokenizer(currentToken.substring(1) + " seconds", " ");
        } else if (!tokenizer.hasMoreTokens() && ExpiresFilter.startsWithIgnoreCase(currentToken, "m")) {
            startingPoint = StartingPoint.LAST_MODIFICATION_TIME;
            tokenizer = new StringTokenizer(currentToken.substring(1) + " seconds", " ");
        } else {
            throw new IllegalStateException("Invalid starting point (access|now|modification|a<seconds>|m<seconds>) '" + currentToken + "' in directive '" + line + "'");
        }
        try {
            currentToken = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Duration not found in directive '" + line + "'");
        }
        if ("plus".equalsIgnoreCase(currentToken)) {
            try {
                currentToken = tokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Duration not found in directive '" + line + "'");
            }
        }
        ArrayList<Duration> durations = new ArrayList<Duration>();
        while (currentToken != null) {
            DurationUnit durationUnit;
            int amount;
            try {
                amount = Integer.parseInt(currentToken);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Invalid duration (number) '" + currentToken + "' in directive '" + line + "'");
            }
            try {
                currentToken = tokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Duration unit not found after amount " + amount + " in directive '" + line + "'");
            }
            if ("year".equalsIgnoreCase(currentToken) || "years".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.YEAR;
            } else if ("month".equalsIgnoreCase(currentToken) || "months".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.MONTH;
            } else if ("week".equalsIgnoreCase(currentToken) || "weeks".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.WEEK;
            } else if ("day".equalsIgnoreCase(currentToken) || "days".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.DAY;
            } else if ("hour".equalsIgnoreCase(currentToken) || "hours".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.HOUR;
            } else if ("minute".equalsIgnoreCase(currentToken) || "minutes".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.MINUTE;
            } else if ("second".equalsIgnoreCase(currentToken) || "seconds".equalsIgnoreCase(currentToken)) {
                durationUnit = DurationUnit.SECOND;
            } else {
                throw new IllegalStateException("Invalid duration unit (years|months|weeks|days|hours|minutes|seconds) '" + currentToken + "' in directive '" + line + "'");
            }
            Duration duration = new Duration(amount, durationUnit);
            durations.add(duration);
            if (tokenizer.hasMoreTokens()) {
                currentToken = tokenizer.nextToken();
                continue;
            }
            currentToken = null;
        }
        return new ExpiresConfiguration(startingPoint, durations);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDefaultExpiresConfiguration(ExpiresConfiguration defaultExpiresConfiguration) {
        this.defaultExpiresConfiguration = defaultExpiresConfiguration;
    }

    public void setExcludedResponseStatusCodes(int[] excludedResponseStatusCodes) {
        this.excludedResponseStatusCodes = excludedResponseStatusCodes;
    }

    public void setExpiresConfigurationByContentType(Map<String, ExpiresConfiguration> expiresConfigurationByContentType) {
        this.expiresConfigurationByContentType = expiresConfigurationByContentType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[active=" + this.active + ", excludedResponseStatusCode=[" + ExpiresFilter.intsToCommaDelimitedString(this.excludedResponseStatusCodes) + "], default=" + this.defaultExpiresConfiguration + ", byType=" + this.expiresConfigurationByContentType + "]";
    }

    public class XServletOutputStream
    extends ServletOutputStream {
        private HttpServletRequest request;
        private XHttpServletResponse response;
        private ServletOutputStream servletOutputStream;

        public XServletOutputStream(ServletOutputStream servletOutputStream, HttpServletRequest request, XHttpServletResponse response) {
            this.servletOutputStream = servletOutputStream;
            this.response = response;
            this.request = request;
        }

        public void close() throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.close();
        }

        private void fireOnBeforeWriteResponseBodyEvent() {
            if (!this.response.isWriteResponseBodyStarted()) {
                this.response.setWriteResponseBodyStarted(true);
                ExpiresFilter.this.onBeforeWriteResponseBody(this.request, this.response);
            }
        }

        public void flush() throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.flush();
        }

        public void print(boolean b) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(b);
        }

        public void print(char c) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(c);
        }

        public void print(double d) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(d);
        }

        public void print(float f) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(f);
        }

        public void print(int i) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(i);
        }

        public void print(long l) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(l);
        }

        public void print(String s) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.print(s);
        }

        public void println() throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println();
        }

        public void println(boolean b) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(b);
        }

        public void println(char c) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(c);
        }

        public void println(double d) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(d);
        }

        public void println(float f) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(f);
        }

        public void println(int i) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(i);
        }

        public void println(long l) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(l);
        }

        public void println(String s) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.println(s);
        }

        public void write(byte[] b) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.fireOnBeforeWriteResponseBodyEvent();
            this.servletOutputStream.write(b);
        }
    }

    public class XPrintWriter
    extends PrintWriter {
        private PrintWriter out;
        private HttpServletRequest request;
        private XHttpServletResponse response;

        public XPrintWriter(PrintWriter out, HttpServletRequest request, XHttpServletResponse response) {
            super(out);
            this.out = out;
            this.request = request;
            this.response = response;
        }

        public PrintWriter append(char c) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.append(c);
        }

        public PrintWriter append(CharSequence csq) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.append(csq);
        }

        public PrintWriter append(CharSequence csq, int start, int end) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.append(csq, start, end);
        }

        public void close() {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.close();
        }

        private void fireBeforeWriteResponseBodyEvent() {
            if (!this.response.isWriteResponseBodyStarted()) {
                this.response.setWriteResponseBodyStarted(true);
                ExpiresFilter.this.onBeforeWriteResponseBody(this.request, this.response);
            }
        }

        public void flush() {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.flush();
        }

        public void print(boolean b) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(b);
        }

        public void print(char c) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(c);
        }

        public void print(char[] s) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(s);
        }

        public void print(double d) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(d);
        }

        public void print(float f) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(f);
        }

        public void print(int i) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(i);
        }

        public void print(long l) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(l);
        }

        public void print(Object obj) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(obj);
        }

        public void print(String s) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.print(s);
        }

        public PrintWriter printf(Locale l, String format, Object ... args) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.printf(l, format, args);
        }

        public PrintWriter printf(String format, Object ... args) {
            this.fireBeforeWriteResponseBodyEvent();
            return this.out.printf(format, args);
        }

        public void println() {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println();
        }

        public void println(boolean x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(char x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(char[] x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(double x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(float x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(int x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(long x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(Object x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void println(String x) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.println(x);
        }

        public void write(char[] buf) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(buf);
        }

        public void write(char[] buf, int off, int len) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(buf, off, len);
        }

        public void write(int c) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(c);
        }

        public void write(String s) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(s);
        }

        public void write(String s, int off, int len) {
            this.fireBeforeWriteResponseBodyEvent();
            this.out.write(s, off, len);
        }
    }

    public class XHttpServletResponse
    extends HttpServletResponseWrapper {
        private String cacheControlHeader;
        private long lastModifiedHeader;
        private PrintWriter printWriter;
        private HttpServletRequest request;
        private ServletOutputStream servletOutputStream;
        private int status;
        private boolean writeResponseBodyStarted;

        public XHttpServletResponse(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.status = 200;
            this.request = request;
        }

        public void addDateHeader(String name, long date) {
            super.addDateHeader(name, date);
            if (!this.containsHeader(ExpiresFilter.HEADER_LAST_MODIFIED)) {
                this.lastModifiedHeader = date;
            }
        }

        public void addHeader(String name, String value) {
            super.addHeader(name, value);
            if (ExpiresFilter.HEADER_CACHE_CONTROL.equalsIgnoreCase(name) && this.cacheControlHeader == null) {
                this.cacheControlHeader = value;
            }
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public boolean isLastModifiedHeaderSet() {
            return this.containsHeader(ExpiresFilter.HEADER_LAST_MODIFIED);
        }

        public long getLastModifiedHeader() {
            return this.lastModifiedHeader;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.servletOutputStream == null) {
                this.servletOutputStream = new XServletOutputStream(super.getOutputStream(), this.request, this);
            }
            return this.servletOutputStream;
        }

        public int getStatus() {
            return this.status;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.printWriter == null) {
                this.printWriter = new XPrintWriter(super.getWriter(), this.request, this);
            }
            return this.printWriter;
        }

        public boolean isWriteResponseBodyStarted() {
            return this.writeResponseBodyStarted;
        }

        public void sendError(int sc) throws IOException {
            this.status = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.status = sc;
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.status = 302;
            super.sendRedirect(location);
        }

        public void setDateHeader(String name, long date) {
            super.setDateHeader(name, date);
            if (ExpiresFilter.HEADER_LAST_MODIFIED.equalsIgnoreCase(name)) {
                this.lastModifiedHeader = date;
            }
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
            if (ExpiresFilter.HEADER_CACHE_CONTROL.equalsIgnoreCase(name)) {
                this.cacheControlHeader = value;
            }
        }

        public void setStatus(int sc) {
            this.status = sc;
            super.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.status = sc;
            super.setStatus(sc, sm);
        }

        public void setWriteResponseBodyStarted(boolean writeResponseBodyStarted) {
            this.writeResponseBodyStarted = writeResponseBodyStarted;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum StartingPoint {
        ACCESS_TIME,
        LAST_MODIFICATION_TIME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExpiresConfiguration {
        private List<Duration> durations;
        private StartingPoint startingPoint;

        public ExpiresConfiguration(StartingPoint startingPoint, Duration ... durations) {
            this(startingPoint, Arrays.asList(durations));
        }

        public ExpiresConfiguration(StartingPoint startingPoint, List<Duration> durations) {
            this.startingPoint = startingPoint;
            this.durations = durations;
        }

        public List<Duration> getDurations() {
            return this.durations;
        }

        public StartingPoint getStartingPoint() {
            return this.startingPoint;
        }

        public String toString() {
            return "ExpiresConfiguration[startingPoint=" + (Object)((Object)this.startingPoint) + ", duration=" + this.durations + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DurationUnit {
        DAY(6),
        HOUR(10),
        MINUTE(12),
        MONTH(2),
        SECOND(13),
        WEEK(3),
        YEAR(1);

        private final int calendardField;

        private DurationUnit(int calendardField) {
            this.calendardField = calendardField;
        }

        public int getCalendardField() {
            return this.calendardField;
        }
    }

    protected static class Duration {
        protected final int amount;
        protected final DurationUnit unit;

        public static Duration minutes(int amount) {
            return new Duration(amount, DurationUnit.MINUTE);
        }

        public static Duration seconds(int amount) {
            return new Duration(amount, DurationUnit.SECOND);
        }

        public Duration(int amount, DurationUnit unit) {
            this.amount = amount;
            this.unit = unit;
        }

        public int getAmount() {
            return this.amount;
        }

        public DurationUnit getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.amount + " " + (Object)((Object)this.unit);
        }
    }
}

