/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.ModelManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;

public class BaseSecurityService
extends AbstractLogEnabled
implements SecurityService,
Configurable,
Initializable,
Serviceable,
ThreadSafe {
    private boolean disposed = false;
    private ServiceManager manager = null;
    String userClassName;
    String groupClassName;
    String permissionClassName;
    String roleClassName;
    String aclClassName;
    protected UserManager userManager = null;
    protected RoleManager roleManager = null;
    protected GroupManager groupManager = null;
    protected PermissionManager permissionManager = null;
    protected ModelManager modelManager = null;

    public UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)this.manager.lookup(UserManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new RuntimeException(ce.getMessage(), ce);
            }
        }
        return this.userManager;
    }

    public GroupManager getGroupManager() {
        if (this.groupManager == null) {
            try {
                this.groupManager = (GroupManager)this.manager.lookup(GroupManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new RuntimeException(ce.getMessage(), ce);
            }
        }
        return this.groupManager;
    }

    public RoleManager getRoleManager() {
        if (this.roleManager == null) {
            try {
                this.roleManager = (RoleManager)this.manager.lookup(RoleManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new RuntimeException(ce.getMessage(), ce);
            }
        }
        return this.roleManager;
    }

    public PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            try {
                this.permissionManager = (PermissionManager)this.manager.lookup(PermissionManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new RuntimeException(ce.getMessage(), ce);
            }
        }
        return this.permissionManager;
    }

    public ModelManager getModelManager() {
        if (this.modelManager == null) {
            try {
                this.modelManager = (ModelManager)this.manager.lookup(ModelManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new RuntimeException(ce.getMessage(), ce);
            }
        }
        return this.modelManager;
    }

    public void configure(Configuration conf) throws ConfigurationException {
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        this.userClassName = null;
        this.groupClassName = null;
        this.permissionClassName = null;
        this.roleClassName = null;
        this.aclClassName = null;
    }

    public void dispose() {
        this.manager.release((Object)this.userManager);
        this.manager.release((Object)this.roleManager);
        this.manager.release((Object)this.groupManager);
        this.manager.release((Object)this.permissionManager);
        this.manager.release((Object)this.modelManager);
        this.manager = null;
    }
}

