/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.authenticator;

import java.security.NoSuchAlgorithmException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.crypto.CryptoAlgorithm;
import org.apache.fulcrum.crypto.CryptoService;
import org.apache.fulcrum.security.authenticator.Authenticator;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.DataBackendException;

public class CryptoAuthenticator
extends AbstractLogEnabled
implements Authenticator,
Serviceable,
Disposable,
Configurable {
    private static Log log;
    boolean composed = false;
    protected CryptoService cryptoService = null;
    private String algorithm;
    private String cipher;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.authenticator.CryptoAuthenticator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean authenticate(User user, String password) throws DataBackendException {
        try {
            CryptoAlgorithm ca = this.cryptoService.getCryptoAlgorithm(this.algorithm);
            ca.setCipher(this.cipher);
            String output = ca.encrypt(password);
            return output.equals(user.getPassword());
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataBackendException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new DataBackendException(ex.getMessage(), ex);
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.algorithm = conf.getChild("algorithm").getValue();
        this.cipher = conf.getChild("cipher").getValue();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.cryptoService = (CryptoService)manager.lookup(CryptoService.ROLE);
    }

    public void dispose() {
        this.cryptoService = null;
    }
}

