/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.basic.test;

import junit.framework.Assert;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.basic.BasicModelManager;
import org.apache.fulcrum.security.model.basic.entity.BasicGroup;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractModelManagerTest
extends BaseUnitTest {
    protected Role role;
    protected BasicModelManager modelManager;
    protected GroupManager groupManager;
    protected UserManager userManager;
    protected SecurityService securityService;

    public void setUp() throws Exception {
        super.setUp();
        this.userManager = this.securityService.getUserManager();
        this.groupManager = this.securityService.getGroupManager();
        this.modelManager = (BasicModelManager)this.securityService.getModelManager();
    }

    public AbstractModelManagerTest(String arg0) {
        super(arg0);
    }

    public void testRevokeAllUser() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKEALL");
        this.securityService.getGroupManager().addGroup(group);
        Group group2 = this.securityService.getGroupManager().getGroupInstance();
        group2.setName("TEST_REVOKEALL2");
        this.securityService.getGroupManager().addGroup(group2);
        User user = this.userManager.getUserInstance("Clint2");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group);
        this.modelManager.grant(user, group2);
        this.modelManager.revokeAll(user);
        Assert.assertEquals((int)0, (int)((BasicUser)user).getGroups().size());
        group = this.securityService.getGroupManager().getGroupByName("TEST_REVOKEALL");
        group2 = this.securityService.getGroupManager().getGroupByName("TEST_REVOKEALL2");
        Assert.assertFalse((boolean)((BasicGroup)group).getUsersAsSet().contains(user));
        Assert.assertFalse((boolean)((BasicGroup)group2).getUsers().contains(user));
    }

    public void testGrantUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Clint");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group);
        Assert.assertTrue((boolean)((BasicUser)user).getGroups().contains(group));
        Assert.assertTrue((boolean)((BasicGroup)group).getUsers().contains(user));
    }

    public void testRevokeUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKE");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Lima");
        this.userManager.addUser(user, "pet");
        this.modelManager.revoke(user, group);
        Assert.assertFalse((boolean)((BasicUser)user).getGroups().contains(group));
        Assert.assertFalse((boolean)((BasicGroup)group).getUsers().contains(user));
        user = this.userManager.getUser("Lima");
        Assert.assertFalse((boolean)((BasicUser)user).getGroups().contains(group));
    }
}

