/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic;

import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractDynamicModelManager
extends AbstractManager
implements DynamicModelManager {
    public synchronized void revokeAll(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        permissionExists = this.getPermissionManager().checkExists(permission);
        if (permissionExists) {
            Object[] roles = ((DynamicPermission)permission).getRoles().toArray();
            int i = 0;
            while (i < roles.length) {
                this.revoke((Role)roles[i], permission);
                ++i;
            }
            return;
        }
        throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
    }

    public synchronized void revokeAll(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        groupExists = this.getGroupManager().checkExists(group);
        if (groupExists) {
            Object[] users = ((DynamicGroup)group).getUsers().toArray();
            int i = 0;
            while (i < users.length) {
                this.revoke((User)users[i], group);
                ++i;
            }
            Object[] roles = ((DynamicGroup)group).getRoles().toArray();
            int i2 = 0;
            while (i2 < roles.length) {
                this.revoke(group, (Role)roles[i2]);
                ++i2;
            }
            return;
        }
        throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.getUserManager().checkExists(user);
        if (userExists) {
            Object[] groups = ((DynamicUser)user).getGroups().toArray();
            int i = 0;
            while (i < groups.length) {
                this.revoke(user, (Group)groups[i]);
                ++i;
            }
            return;
        }
        throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
    }

    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        roleExists = this.getRoleManager().checkExists(role);
        if (roleExists) {
            Object[] groups = ((DynamicRole)role).getGroups().toArray();
            int i = 0;
            while (i < groups.length) {
                this.revoke((Group)groups[i], role);
                ++i;
            }
            Object[] permissions = ((DynamicRole)role).getPermissions().toArray();
            int i2 = 0;
            while (i2 < permissions.length) {
                this.revoke(role, (Permission)permissions[i2]);
                ++i2;
            }
        } else {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public void addDelegate(User delegator, User delegatee) throws DataBackendException, UnknownEntityException {
        DynamicUser dynamicDelegator = (DynamicUser)delegator;
        DynamicUser dynamicDelegatee = (DynamicUser)delegatee;
        if (!dynamicDelegator.getDelegatees().contains(delegatee) && !dynamicDelegatee.getDelegators().contains(delegator)) {
            dynamicDelegator.getDelegatees().add(dynamicDelegatee);
            dynamicDelegatee.getDelegators().add(dynamicDelegator);
        }
    }

    public void removeDelegate(User delegator, User delegatee) throws DataBackendException, UnknownEntityException {
        DynamicUser dynamicDelegator = (DynamicUser)delegator;
        DynamicUser dynamicDelegatee = (DynamicUser)delegatee;
        if (!dynamicDelegator.getDelegatees().contains(dynamicDelegatee)) {
            throw new UnknownEntityException("Tried to remove a delegate that does not exist");
        }
        dynamicDelegator.getDelegatees().remove(dynamicDelegatee);
        dynamicDelegatee.getDelegators().remove(dynamicDelegator);
    }
}

