/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlListImpl;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class DynamicACLFactory
extends AbstractManager
implements ACLFactory {
    private static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.model.dynamic.DynamicACLFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private AccessControlList getAclInstance(Map roles, Map permissions) throws UnknownEntityException {
        DynamicAccessControlListImpl accessControlList;
        Object[] objects = new Object[]{roles, permissions};
        String[] stringArray = new String[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        String[] signatures = stringArray;
        try {
            accessControlList = new DynamicAccessControlListImpl(roles, permissions);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }

    public AccessControlList getAccessControlList(User user) {
        HashMap roleSets = new HashMap();
        HashMap permissionSets = new HashMap();
        HashSet<User> users = new HashSet<User>();
        users.add(user);
        this.addDelegators((DynamicUser)user, users);
        Iterator i = users.iterator();
        while (i.hasNext()) {
            DynamicUser aUser = (DynamicUser)i.next();
            this.addRolesAndPermissions(aUser, roleSets, permissionSets);
        }
        try {
            return this.getAclInstance(roleSets, permissionSets);
        }
        catch (UnknownEntityException uue) {
            throw new RuntimeException(uue.getMessage(), uue);
        }
    }

    public void addDelegators(DynamicUser user, Set users) {
        Iterator iter = user.getDelegators().iterator();
        while (iter.hasNext()) {
            DynamicUser delegatorUser = (DynamicUser)iter.next();
            if (!users.add(delegatorUser)) continue;
            this.addDelegators(delegatorUser, users);
        }
    }

    private void addRolesAndPermissions(User user, Map roleSets, Map permissionSets) {
        Iterator i = ((DynamicUser)user).getGroups().iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            RoleSet roleSet = ((DynamicGroup)group).getRoles();
            roleSets.put(group, roleSet);
            Iterator j = roleSet.iterator();
            while (j.hasNext()) {
                DynamicRole role = (DynamicRole)j.next();
                permissionSets.put(role, role.getPermissions());
            }
        }
    }
}

