/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic;

import java.util.Iterator;
import java.util.Map;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlList;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;

public class DynamicAccessControlListImpl
implements DynamicAccessControlList {
    private Map roleSets;
    private Map permissionSets;
    private GroupSet groupSet = new GroupSet();
    private RoleSet roleSet = new RoleSet();
    private PermissionSet permissionSet = new PermissionSet();

    public DynamicAccessControlListImpl(Map roleSets, Map permissionSets) {
        this.roleSets = roleSets;
        this.permissionSets = permissionSets;
        Iterator i = roleSets.keySet().iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            this.groupSet.add(group);
            RoleSet rs = (RoleSet)roleSets.get(group);
            this.roleSet.add(rs);
        }
        i = permissionSets.keySet().iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            this.roleSet.add(role);
            PermissionSet ps = (PermissionSet)permissionSets.get(role);
            this.permissionSet.add(ps);
        }
    }

    public RoleSet getRoles(Group group) {
        if (group == null) {
            return null;
        }
        return (RoleSet)this.roleSets.get(group);
    }

    public RoleSet getRoles() {
        return this.roleSet;
    }

    public PermissionSet getPermissions(Group group) {
        PermissionSet permissionSet = new PermissionSet();
        if (this.roleSets.containsKey(group)) {
            RoleSet rs = (RoleSet)this.roleSets.get(group);
            Iterator i = rs.iterator();
            while (i.hasNext()) {
                Role role = (Role)i.next();
                if (!this.permissionSets.containsKey(role)) continue;
                permissionSet.add((PermissionSet)this.permissionSets.get(role));
            }
        }
        return permissionSet;
    }

    public PermissionSet getPermissions() {
        return this.permissionSet;
    }

    public boolean hasRole(Role role, Group group) {
        RoleSet set = this.getRoles(group);
        if (set == null || role == null) {
            return false;
        }
        return set.contains(role);
    }

    public boolean hasRole(Role role, GroupSet groupset) {
        if (role == null) {
            return false;
        }
        Iterator groups = groupset.iterator();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String role, String group) {
        boolean roleFound = false;
        try {
            Iterator i = this.roleSets.keySet().iterator();
            while (i.hasNext()) {
                Group g = (Group)i.next();
                if (!g.getName().equalsIgnoreCase(group)) continue;
                RoleSet rs = (RoleSet)this.roleSets.get(g);
                roleFound = rs.containsName(role);
            }
        }
        catch (Exception e) {
            roleFound = false;
        }
        return roleFound;
    }

    public boolean hasRole(String rolename, GroupSet groupset) {
        Role role;
        try {
            role = this.roleSet.getRoleByName(rolename);
        }
        catch (Exception e) {
            return false;
        }
        if (role == null) {
            return false;
        }
        Iterator groups = groupset.iterator();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        return this.roleSet.contains(role);
    }

    public boolean hasRole(String role) {
        try {
            return this.roleSet.containsName(role);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(Permission permission, Group group) {
        PermissionSet set = this.getPermissions(group);
        if (set == null || permission == null) {
            return false;
        }
        return set.contains(permission);
    }

    public boolean hasPermission(Permission permission, GroupSet groupset) {
        if (permission == null) {
            return false;
        }
        Iterator groups = groupset.iterator();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(String permission, String group) {
        try {
            return this.hasPermission(this.permissionSet.getPermissionByName(permission), this.groupSet.getGroupByName(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(String permission, Group group) {
        try {
            return this.hasPermission(this.permissionSet.getPermissionByName(permission), group);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(String permissionName, GroupSet groupset) {
        Permission permission;
        try {
            permission = this.permissionSet.getPermissionByName(permissionName);
        }
        catch (Exception e) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        Iterator groups = groupset.iterator();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Permission permission) {
        return this.permissionSet.contains(permission);
    }

    public boolean hasPermission(String permission) {
        try {
            return this.permissionSet.containsName(permission);
        }
        catch (Exception e) {
            return false;
        }
    }
}

