/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.dynamic.test;

import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.DynamicAccessControlList;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractDynamicModelManagerTest
extends BaseUnitTest {
    private static final String ONLY_BORRIS_PERMISSION = "ONLY_BORRIS_PERMISSION";
    private static final String ONLY_BORRIS_GROUP = "ONLY_BORRIS_GROUP";
    private static final String ONLY_BORRIS_ROLE = "ONLY BORRIS ROLE";
    private static final String USERNAME_SAM = "sam1";
    private static final String USERNAME_BORRIS = "borris1";
    protected Role role;
    protected DynamicModelManager modelManager;
    protected RoleManager roleManager;
    protected GroupManager groupManager;
    protected PermissionManager permissionManager;
    protected UserManager userManager;
    protected SecurityService securityService;

    public void setUp() throws Exception {
        super.setUp();
        this.roleManager = this.securityService.getRoleManager();
        this.userManager = this.securityService.getUserManager();
        this.groupManager = this.securityService.getGroupManager();
        this.permissionManager = this.securityService.getPermissionManager();
        this.modelManager = (DynamicModelManager)this.securityService.getModelManager();
    }

    public void tearDown() {
        this.release(this.roleManager);
        this.release(this.userManager);
        this.release(this.groupManager);
        this.release(this.permissionManager);
        this.release(this.modelManager);
    }

    public AbstractDynamicModelManagerTest(String arg0) {
        super(arg0);
    }

    public void testGrantRolePermission() throws Exception {
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName("ANSWER_PHONE");
        this.permissionManager.addPermission(permission);
        this.role = this.roleManager.getRoleInstance("RECEPTIONIST");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)1, (int)permissions.size());
        Assert.assertTrue((boolean)((DynamicRole)this.role).getPermissions().contains(permission));
    }

    public void testRevokeRolePermission() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("ANSWER_FAX");
        this.securityService.getPermissionManager().addPermission(permission);
        this.role = this.roleManager.getRoleInstance("SECRETARY");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)1, (int)permissions.size());
        this.modelManager.revoke(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)0, (int)permissions.size());
        Assert.assertFalse((boolean)((DynamicRole)this.role).getPermissions().contains(permission));
    }

    public void testRevokeAllRole() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("SEND_SPAM");
        permission2.setName("ANSWER_EMAIL");
        this.securityService.getPermissionManager().addPermission(permission);
        this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("HELPER");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revokeAll(this.role);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)0, (int)permissions.size());
    }

    public void testRevokeAllGroup() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("SEND_SPAM2");
        permission2.setName("ANSWER_EMAIL2");
        this.securityService.getPermissionManager().addPermission(permission);
        this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("HELPER2");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revokeAll(this.role);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((DynamicRole)this.role).getPermissions();
        Assert.assertEquals((int)0, (int)permissions.size());
    }

    public void testRevokeAllUser() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKEALLUSER_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_REVOKEALLUSER_ROLE");
        this.securityService.getRoleManager().addRole(role);
        User user = this.userManager.getUserInstance("calvin");
        this.userManager.addUser(user, "calvin");
        this.modelManager.grant(user, group);
        this.modelManager.grant(group, role);
        group = this.groupManager.getGroupById(group.getId());
        RoleSet roles = ((DynamicGroup)group).getRoles();
        Assert.assertEquals((int)1, (int)roles.size());
        UserSet users = ((DynamicGroup)group).getUsers();
        Assert.assertEquals((int)1, (int)users.size());
        this.modelManager.revokeAll(group);
        Assert.assertEquals((int)0, (int)((DynamicGroup)group).getUsers().size());
        role = this.securityService.getRoleManager().getRoleByName("TEST_REVOKEALLUSER_ROLE");
        Assert.assertFalse((boolean)((DynamicRole)role).getGroups().contains(group));
    }

    public void testRevokeAllPermission() throws Exception {
        Role role = this.securityService.getRoleManager().getRoleInstance();
        Role role2 = this.securityService.getRoleManager().getRoleInstance();
        role.setName("SEND_SPAM");
        role2.setName("ANSWER_EMAIL");
        this.securityService.getRoleManager().addRole(role);
        this.securityService.getRoleManager().addRole(role2);
        Permission permission = this.permissionManager.getPermissionInstance("HELPER");
        this.permissionManager.addPermission(permission);
        this.modelManager.grant(role, permission);
        this.modelManager.grant(role2, permission);
        permission = this.permissionManager.getPermissionById(permission.getId());
        RoleSet roles = ((DynamicPermission)permission).getRoles();
        Assert.assertEquals((int)2, (int)roles.size());
        this.modelManager.revokeAll(permission);
        permission = this.permissionManager.getPermissionById(permission.getId());
        roles = ((DynamicPermission)permission).getRoles();
        Assert.assertEquals((int)0, (int)roles.size());
    }

    public void testGrantUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Clint");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group);
        Assert.assertTrue((boolean)((DynamicUser)user).getGroups().contains(group));
        Assert.assertTrue((boolean)((DynamicGroup)group).getUsers().contains(user));
    }

    public void testRevokeUserGroup() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKE");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Lima");
        this.userManager.addUser(user, "pet");
        this.modelManager.revoke(user, group);
        Assert.assertFalse((boolean)((DynamicUser)user).getGroups().contains(group));
        Assert.assertFalse((boolean)((DynamicGroup)group).getUsers().contains(user));
        user = this.userManager.getUser("Lima");
        Assert.assertFalse((boolean)((DynamicUser)user).getGroups().contains(group));
    }

    public void testGrantGroupRole() throws Exception {
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_PERMISSION");
        this.securityService.getRoleManager().addRole(role);
        Group group = this.groupManager.getGroupInstance("TEST_GROUP2");
        this.groupManager.addGroup(group);
        this.modelManager.grant(group, role);
        group = this.groupManager.getGroupByName("TEST_GROUP2");
        Assert.assertTrue((boolean)((DynamicGroup)group).getRoles().contains(role));
        Assert.assertTrue((boolean)((DynamicRole)role).getGroups().contains(group));
    }

    public void testRevokeGroupRole() throws Exception {
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_PERMISSION2");
        this.securityService.getRoleManager().addRole(role);
        Group group = this.groupManager.getGroupInstance("Lima2");
        this.groupManager.addGroup(group);
        this.modelManager.grant(group, role);
        this.modelManager.revoke(group, role);
        group = this.groupManager.getGroupByName("Lima2");
        Assert.assertFalse((boolean)((DynamicGroup)group).getRoles().contains(role));
        Assert.assertFalse((boolean)((DynamicRole)role).getGroups().contains(group));
    }

    public void testRetrieveingUsersByGroup() throws Exception {
        User user = this.userManager.getUserInstance("Joe3");
        this.userManager.addUser(user, "mc");
        String GROUP_NAME = "oddbug2";
        Group group = null;
        GroupManager groupManager = this.securityService.getGroupManager();
        try {
            group = groupManager.getGroupByName("");
        }
        catch (UnknownEntityException uue) {
            group = groupManager.getGroupInstance(GROUP_NAME);
            groupManager.addGroup(group);
        }
        Assert.assertNotNull((Object)group);
        user = null;
        UserManager userManager = this.securityService.getUserManager();
        user = userManager.getUser("joe3");
        ((DynamicModelManager)this.securityService.getModelManager()).grant(user, group);
        Assert.assertTrue((boolean)((DynamicGroup)group).getUsers().contains(user));
        group = groupManager.getGroupByName(GROUP_NAME);
        UserSet users = ((DynamicGroup)group).getUsers();
        int size = users.size();
        Assert.assertEquals((int)1, (int)size);
        boolean found = false;
        HashSet<User> newSet = new HashSet<User>();
        Iterator i = users.iterator();
        while (i.hasNext()) {
            User u = (User)i.next();
            if (!u.equals(user)) continue;
            found = true;
            newSet.add(u);
        }
        Assert.assertTrue((boolean)found);
        Assert.assertTrue((boolean)users.contains((Object)user));
    }

    public void testAddRemoveDelegate() throws Exception {
        DynamicUser borris = (DynamicUser)this.userManager.getUserInstance(USERNAME_BORRIS);
        this.userManager.addUser(borris, "mc");
        DynamicUser sam = (DynamicUser)this.userManager.getUserInstance(USERNAME_SAM);
        this.userManager.addUser(sam, "mc");
        this.modelManager.addDelegate(borris, sam);
        Assert.assertTrue((boolean)borris.getDelegatees().contains(sam));
        Assert.assertTrue((boolean)sam.getDelegators().contains(borris));
        DynamicUser borrisLoaded = (DynamicUser)this.userManager.getUser(USERNAME_BORRIS);
        DynamicUser samLoaded = (DynamicUser)this.userManager.getUser(USERNAME_SAM);
        Assert.assertTrue((boolean)borrisLoaded.getDelegatees().contains(samLoaded));
        Assert.assertTrue((boolean)samLoaded.getDelegators().contains(borrisLoaded));
        Group group = this.groupManager.getGroupInstance();
        group.setName(ONLY_BORRIS_GROUP);
        this.groupManager.addGroup(group);
        Role role = this.roleManager.getRoleInstance();
        role.setName(ONLY_BORRIS_ROLE);
        this.roleManager.addRole(role);
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName(ONLY_BORRIS_PERMISSION);
        this.permissionManager.addPermission(permission);
        this.modelManager.grant(role, permission);
        this.modelManager.grant(group, role);
        this.modelManager.grant(borris, group);
        DynamicAccessControlList acl = (DynamicAccessControlList)this.userManager.getACL(sam);
        Assert.assertTrue((boolean)acl.hasPermission(permission));
        Assert.assertTrue((boolean)acl.hasRole(role));
        this.modelManager.addDelegate(sam, borris);
        acl = (DynamicAccessControlList)this.userManager.getACL(sam);
        Assert.assertTrue((boolean)acl.hasPermission(permission));
        Assert.assertTrue((boolean)acl.hasRole(role));
        this.modelManager.removeDelegate(borris, sam);
        Assert.assertFalse((boolean)borris.getDelegatees().contains(sam));
        Assert.assertFalse((boolean)sam.getDelegators().contains(borris));
        borrisLoaded = (DynamicUser)this.userManager.getUser(USERNAME_BORRIS);
        samLoaded = (DynamicUser)this.userManager.getUser(USERNAME_BORRIS);
        Assert.assertFalse((boolean)borrisLoaded.getDelegatees().contains(samLoaded));
        Assert.assertFalse((boolean)samLoaded.getDelegators().contains(borrisLoaded));
        boolean thrown = false;
        try {
            this.modelManager.removeDelegate(borris, sam);
        }
        catch (DataBackendException e) {
            throw e;
        }
        catch (UnknownEntityException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }
}

