/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import junit.framework.Assert;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractGroupManagerTest
extends BaseUnitTest {
    protected Group group;
    protected GroupManager groupManager;
    protected SecurityService securityService;

    public AbstractGroupManagerTest(String arg0) {
        super(arg0);
    }

    public void testGetGroupInstance() throws Exception {
        this.group = this.groupManager.getGroupInstance();
        Assert.assertNotNull((Object)this.group);
        Assert.assertTrue((this.group.getName() == null ? 1 : 0) != 0);
    }

    public void testGetGroupInstanceString() throws Exception {
        this.group = this.groupManager.getGroupInstance("DOG_CATCHER");
        Assert.assertEquals((String)"DOG_CATCHER".toLowerCase(), (String)this.group.getName());
    }

    public void testGetGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("DOG_CATCHER2");
        this.groupManager.addGroup(this.group);
        Group group2 = this.groupManager.getGroupByName("DOG_CATCHER2");
        Assert.assertEquals((String)this.group.getName(), (String)group2.getName());
    }

    public void testGetGroupByName() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL");
        this.groupManager.addGroup(this.group);
        Group group2 = this.groupManager.getGroupByName("CLEAN_KENNEL");
        Assert.assertEquals((String)this.group.getName(), (String)group2.getName());
        group2 = this.groupManager.getGroupByName("Clean_KeNNel");
        Assert.assertEquals((String)this.group.getName(), (String)group2.getName());
    }

    public void testGetGroupById() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_A");
        this.groupManager.addGroup(this.group);
        Group group2 = this.groupManager.getGroupById(this.group.getId());
        Assert.assertEquals((String)this.group.getName(), (String)group2.getName());
    }

    public void testGetAllGroups() throws Exception {
        int size = this.groupManager.getAllGroups().size();
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_J");
        this.groupManager.addGroup(this.group);
        GroupSet groupSet = this.groupManager.getAllGroups();
        Assert.assertEquals((int)(size + 1), (int)groupSet.size());
    }

    public void testRemoveGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_K");
        this.groupManager.addGroup(this.group);
        int size = this.groupManager.getAllGroups().size();
        if (this.group instanceof DynamicGroup) {
            Assert.assertEquals((int)0, (int)((DynamicGroup)this.group).getUsers().size());
            Assert.assertEquals((int)0, (int)((DynamicGroup)this.group).getRoles().size());
        }
        this.groupManager.removeGroup(this.group);
        try {
            Group group2 = this.groupManager.getGroupById(this.group.getId());
            Assert.fail((String)"Should have thrown UEE");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        Assert.assertEquals((int)(size - 1), (int)this.groupManager.getAllGroups().size());
    }

    public void testRenameGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_KENNEL_X");
        this.groupManager.addGroup(this.group);
        int size = this.groupManager.getAllGroups().size();
        this.groupManager.renameGroup(this.group, "CLEAN_GROOMING_ROOM");
        Group group2 = this.groupManager.getGroupById(this.group.getId());
        Assert.assertEquals((String)"CLEAN_GROOMING_ROOM".toLowerCase(), (String)group2.getName());
        Assert.assertEquals((int)size, (int)this.groupManager.getAllGroups().size());
    }

    public void testCheckExists() throws Exception {
        this.group = this.groupManager.getGroupInstance("GREET_PEOPLE");
        this.groupManager.addGroup(this.group);
        Assert.assertTrue((boolean)this.groupManager.checkExists(this.group));
        Group group2 = this.groupManager.getGroupInstance("WALK_DOGS");
        Assert.assertFalse((boolean)this.groupManager.checkExists(group2));
    }

    public void testCheckExistsWithString() throws Exception {
        this.group = this.groupManager.getGroupInstance("GREET_PEOPLE2");
        this.groupManager.addGroup(this.group);
        Assert.assertTrue((boolean)this.groupManager.checkExists(this.group.getName()));
        Group group2 = this.groupManager.getGroupInstance("WALK_DOGS2");
        Assert.assertFalse((boolean)this.groupManager.checkExists(group2.getName()));
    }

    public void testAddGroupTwiceFails() throws Exception {
        this.group = this.groupManager.getGroupInstance("EATLUNCH");
        this.groupManager.addGroup(this.group);
        Assert.assertTrue((boolean)this.groupManager.checkExists(this.group.getName()));
        Group group2 = this.groupManager.getGroupInstance("EATLUNCH");
        try {
            this.groupManager.addGroup(group2);
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }

    public void testAddGroup() throws Exception {
        this.group = this.groupManager.getGroupInstance("CLEAN_RABBIT_HUTCHES");
        Assert.assertNull((Object)this.group.getId());
        this.groupManager.addGroup(this.group);
        Assert.assertNotNull((Object)this.group.getId());
        Assert.assertNotNull((Object)this.groupManager.getGroupById(this.group.getId()));
    }
}

