/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import junit.framework.Assert;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractPermissionManagerTest
extends BaseUnitTest {
    protected Permission permission;
    protected PermissionManager permissionManager;
    protected SecurityService securityService;

    public AbstractPermissionManagerTest(String arg0) {
        super(arg0);
    }

    public void testGetPermissionInstance() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance();
        Assert.assertNotNull((Object)this.permission);
        Assert.assertTrue((this.permission.getName() == null ? 1 : 0) != 0);
    }

    public void testGetPermissionInstanceString() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CAN_TREAT_ANIMALS");
        Assert.assertEquals((String)"can_treat_animals", (String)this.permission.getName());
    }

    public void testGetPermissionByName() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_KENNEL");
        this.permissionManager.addPermission(this.permission);
        Permission permission2 = this.permissionManager.getPermissionByName("CLEAN_KENNEL");
        Assert.assertEquals((String)this.permission.getName(), (String)permission2.getName());
    }

    public void testGetPermissionById() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("ADMINSTER_DRUGS");
        this.permissionManager.addPermission(this.permission);
        Permission permission2 = this.permissionManager.getPermissionById(this.permission.getId());
        Assert.assertEquals((String)this.permission.getName(), (String)permission2.getName());
    }

    public void testGetAllPermissions() throws Exception {
        int size = this.permissionManager.getAllPermissions().size();
        this.permission = this.permissionManager.getPermissionInstance("WALK_DOGS");
        this.permissionManager.addPermission(this.permission);
        PermissionSet permissionSet = this.permissionManager.getAllPermissions();
        Assert.assertEquals((int)(size + 1), (int)permissionSet.size());
    }

    public void testRenamePermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_FRONT_OFFICE");
        this.permissionManager.addPermission(this.permission);
        int size = this.permissionManager.getAllPermissions().size();
        this.permissionManager.renamePermission(this.permission, "CLEAN_GROOMING_ROOM");
        Permission permission2 = this.permissionManager.getPermissionById(this.permission.getId());
        Assert.assertEquals((String)"CLEAN_GROOMING_ROOM".toLowerCase(), (String)permission2.getName());
        Assert.assertEquals((int)size, (int)this.permissionManager.getAllPermissions().size());
    }

    public void testRemovePermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_CAT_HOUSE");
        this.permissionManager.addPermission(this.permission);
        this.permissionManager.removePermission(this.permission);
        try {
            this.permission = this.permissionManager.getPermissionById(this.permission.getId());
            Assert.fail((String)"Should have thrown UnknownEntityException");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public void testAddPermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_BIG_KENNEL");
        Assert.assertNull((Object)this.permission.getId());
        this.permissionManager.addPermission(this.permission);
        Assert.assertNotNull((Object)this.permission.getId());
        this.permission = this.permissionManager.getPermissionById(this.permission.getId());
        Assert.assertNotNull((Object)this.permission);
    }

    public void testGetPermissionsRole() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("GREET_PEOPLE");
        this.permissionManager.addPermission(this.permission);
        Permission permission2 = this.permissionManager.getPermissionInstance("ADMINISTER_DRUGS");
        this.permissionManager.addPermission(permission2);
        Role role = this.securityService.getRoleManager().getRoleInstance("VET_TECH");
        this.securityService.getRoleManager().addRole(role);
        ((DynamicModelManager)this.securityService.getModelManager()).grant(role, this.permission);
        PermissionSet permissions = ((DynamicRole)role).getPermissions();
        Assert.assertEquals((int)1, (int)permissions.size());
        Assert.assertTrue((boolean)permissions.contains(this.permission));
        Assert.assertFalse((boolean)permissions.contains(permission2));
    }

    public void testCheckExistsPermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("OPEN_OFFICE");
        this.permissionManager.addPermission(this.permission);
        Assert.assertTrue((boolean)this.permissionManager.checkExists(this.permission));
        Permission permission2 = this.permissionManager.getPermissionInstance("CLOSE_OFFICE");
        Assert.assertFalse((boolean)this.permissionManager.checkExists(permission2));
    }

    public void testCheckExistsPermissionWithString() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("OPEN_OFFICE2");
        this.permissionManager.addPermission(this.permission);
        Assert.assertTrue((boolean)this.permissionManager.checkExists(this.permission.getName()));
        Permission permission2 = this.permissionManager.getPermissionInstance("CLOSE_OFFICE2");
        Assert.assertFalse((boolean)this.permissionManager.checkExists(permission2.getName()));
    }

    public void testAddPermissionTwiceFails() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("EATLUNCH");
        this.permissionManager.addPermission(this.permission);
        Assert.assertTrue((boolean)this.permissionManager.checkExists(this.permission.getName()));
        Permission permission2 = this.permissionManager.getPermissionInstance("EATLUNCH");
        try {
            this.permissionManager.addPermission(permission2);
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }
}

