/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import junit.framework.Assert;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractRoleManagerTest
extends BaseUnitTest {
    protected Role role;
    protected RoleManager roleManager;
    protected SecurityService securityService;

    public AbstractRoleManagerTest(String arg0) {
        super(arg0);
    }

    public void testGetRoleInstance() throws Exception {
        this.role = this.roleManager.getRoleInstance();
        Assert.assertNotNull((Object)this.role);
        Assert.assertTrue((this.role.getName() == null ? 1 : 0) != 0);
    }

    public void testGetRoleInstanceString() throws Exception {
        this.role = this.roleManager.getRoleInstance("DOG_CATCHER");
        Assert.assertEquals((String)"dog_catcher", (String)this.role.getName());
    }

    public void testGetRoleByName() throws Exception {
        this.role = this.roleManager.getRoleInstance("DOG_CATCHERd");
        this.roleManager.addRole(this.role);
        Role role2 = this.roleManager.getRoleByName("DOG_CATCHERd");
        Assert.assertEquals((String)this.role.getName(), (String)role2.getName());
    }

    public void testGetRoleById() throws Exception {
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_A");
        this.roleManager.addRole(this.role);
        Role role2 = this.roleManager.getRoleById(this.role.getId());
        Assert.assertEquals((String)this.role.getName(), (String)role2.getName());
    }

    public void testRenameRole() throws Exception {
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_X");
        this.roleManager.addRole(this.role);
        int size = this.roleManager.getAllRoles().size();
        this.roleManager.renameRole(this.role, "CLEAN_GROOMING_ROOM");
        Role role2 = this.roleManager.getRoleById(this.role.getId());
        Assert.assertEquals((String)"clean_grooming_room", (String)role2.getName());
        Assert.assertEquals((int)size, (int)this.roleManager.getAllRoles().size());
    }

    public void testGetAllRoles() throws Exception {
        int size = this.roleManager.getAllRoles().size();
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_J");
        this.roleManager.addRole(this.role);
        RoleSet roleSet = this.roleManager.getAllRoles();
        Assert.assertEquals((int)(size + 1), (int)roleSet.size());
    }

    public void testAddRole() throws Exception {
        this.role = this.roleManager.getRoleInstance("DOG_NAPPER");
        Assert.assertNull((Object)this.role.getId());
        this.roleManager.addRole(this.role);
        Assert.assertNotNull((Object)this.role.getId());
        Assert.assertNotNull((Object)this.roleManager.getRoleById(this.role.getId()));
    }

    public void testRemoveRole() throws Exception {
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_K");
        this.roleManager.addRole(this.role);
        int size = this.roleManager.getAllRoles().size();
        this.roleManager.removeRole(this.role);
        try {
            Role role2 = this.roleManager.getRoleById(this.role.getId());
            Assert.fail((String)"Should have thrown UEE");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        Assert.assertEquals((int)(size - 1), (int)this.roleManager.getAllRoles().size());
    }

    public void testCheckExists() throws Exception {
        this.role = this.roleManager.getRoleInstance("GREET_PEOPLE");
        this.roleManager.addRole(this.role);
        Assert.assertTrue((boolean)this.roleManager.checkExists(this.role));
        Role role2 = this.roleManager.getRoleInstance("WALK_DOGS");
        Assert.assertFalse((boolean)this.roleManager.checkExists(role2));
    }

    public void testCheckExistsWithString() throws Exception {
        this.role = this.roleManager.getRoleInstance("GREET_PEOPLE2");
        this.roleManager.addRole(this.role);
        Assert.assertTrue((boolean)this.roleManager.checkExists(this.role.getName()));
        Role role2 = this.roleManager.getRoleInstance("WALK_DOGS2");
        Assert.assertFalse((boolean)this.roleManager.checkExists(role2.getName()));
    }

    public void testAddRoleTwiceFails() throws Exception {
        this.role = this.roleManager.getRoleInstance("EATLUNCH");
        this.roleManager.addRole(this.role);
        Assert.assertTrue((boolean)this.roleManager.checkExists(this.role.getName()));
        Role role2 = this.roleManager.getRoleInstance("EATLUNCH");
        try {
            this.roleManager.addRole(role2);
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }
}

