/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import junit.framework.Assert;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractUserManagerTest
extends BaseUnitTest {
    protected User user;
    protected UserManager userManager;
    protected SecurityService securityService;

    public AbstractUserManagerTest(String arg0) {
        super(arg0);
    }

    public void testCheckExists() throws Exception {
        this.user = this.userManager.getUserInstance("Philip");
        this.userManager.addUser(this.user, "bobo");
        Assert.assertTrue((boolean)this.userManager.checkExists("philip"));
        Assert.assertTrue((boolean)this.userManager.checkExists(this.user));
        Assert.assertFalse((boolean)this.userManager.checkExists("ImaginaryFriend"));
        this.user = this.userManager.getUserInstance("ImaginaryFriend");
        Assert.assertFalse((boolean)this.userManager.checkExists(this.user));
    }

    public void testCheckExistsWithString() throws Exception {
        this.user = this.userManager.getUserInstance("Philip2");
        this.userManager.addUser(this.user, "bobo");
        Assert.assertTrue((boolean)this.userManager.checkExists("philip2"));
        Assert.assertTrue((boolean)this.userManager.checkExists(this.user.getName()));
        Assert.assertFalse((boolean)this.userManager.checkExists("ImaginaryFriend2"));
        this.user = this.userManager.getUserInstance("ImaginaryFriend2");
        Assert.assertFalse((boolean)this.userManager.checkExists(this.user.getName()));
    }

    public void testGetUserString() throws Exception {
        this.user = this.userManager.getUserInstance("QuietMike");
        this.userManager.addUser(this.user, "bobo");
        this.user = this.userManager.getUser("QuietMike");
        Assert.assertNotNull((Object)this.user);
    }

    public void testGetUserById() throws Exception {
        this.user = this.userManager.getUserInstance("QuietMike2");
        this.userManager.addUser(this.user, "bobo");
        User user2 = this.userManager.getUserById(this.user.getId());
        Assert.assertEquals((String)this.user.getName(), (String)user2.getName());
        Assert.assertEquals((Object)this.user.getId(), (Object)user2.getId());
    }

    public void testGetUserStringString() throws Exception {
        this.user = this.userManager.getUserInstance("Richard");
        this.userManager.addUser(this.user, "va");
        this.user = this.userManager.getUser("Richard", "va");
        Assert.assertNotNull((Object)this.user);
        this.user = this.userManager.getUser("richard", "va");
        Assert.assertNotNull((Object)this.user);
        try {
            this.user = this.userManager.getUser("richard", "VA");
            Assert.fail((String)"should have thrown PasswordMismatchException");
        }
        catch (PasswordMismatchException passwordMismatchException) {
            // empty catch block
        }
    }

    public void testGetAllUsers() throws Exception {
        int size = this.userManager.getAllUsers().size();
        this.user = this.userManager.getUserInstance("Bob");
        this.userManager.addUser(this.user, "");
        UserSet userSet = this.userManager.getAllUsers();
        Assert.assertEquals((int)(size + 1), (int)userSet.size());
    }

    public void testAuthenticate() throws Exception {
        this.user = this.userManager.getUserInstance("Kay");
        this.userManager.addUser(this.user, "jc");
        this.userManager.authenticate(this.user, "jc");
        try {
            this.userManager.authenticate(this.user, "JC");
            Assert.fail((String)"should have thrown PasswordMismatchException");
        }
        catch (PasswordMismatchException passwordMismatchException) {
            // empty catch block
        }
    }

    public void testChangePassword() throws Exception {
        this.user = this.userManager.getUserInstance("Jonathan");
        this.userManager.addUser(this.user, "jc");
        try {
            this.userManager.changePassword(this.user, "WrongPWD", "JC");
            Assert.fail((String)"should have thrown PasswordMismatchException");
        }
        catch (PasswordMismatchException passwordMismatchException) {
            // empty catch block
        }
        this.userManager.changePassword(this.user, "jc", "JC");
        this.userManager.authenticate(this.user, "JC");
    }

    public void testForcePassword() throws Exception {
        this.user = this.userManager.getUserInstance("Connor");
        this.userManager.addUser(this.user, "jc_subset");
        this.userManager.forcePassword(this.user, "JC_SUBSET");
        this.userManager.authenticate(this.user, "JC_SUBSET");
    }

    public void testGetUserInstance() throws Exception {
        this.user = this.userManager.getUserInstance();
        Assert.assertNotNull((Object)this.user);
        Assert.assertTrue((this.user.getName() == null ? 1 : 0) != 0);
    }

    public void testGetUserInstanceString() throws Exception {
        this.user = this.userManager.getUserInstance("Philip");
        Assert.assertEquals((String)"philip", (String)this.user.getName());
    }

    public void testSaveUser() throws Exception {
        this.user = this.userManager.getUserInstance("Kate");
        this.userManager.addUser(this.user, "katiedid");
        this.user = this.userManager.getUser(this.user.getName());
        this.userManager.saveUser(this.user);
        Assert.assertEquals((String)"kate", (String)this.userManager.getUser(this.user.getName()).getName());
    }

    public void testGetACL() throws Exception {
        this.user = this.userManager.getUserInstance("Tony");
        this.userManager.addUser(this.user, "california");
        AccessControlList acl = this.userManager.getACL(this.user);
        Assert.assertNotNull((Object)acl);
    }

    public void testRemoveUser() throws Exception {
        this.user = this.userManager.getUserInstance("Rick");
        this.userManager.addUser(this.user, "nb");
        this.userManager.removeUser(this.user);
        try {
            User user2 = this.userManager.getUser(this.user.getName());
            Assert.fail((String)"Should have thrown UEE");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public void testAddUser() throws Exception {
        this.user = this.userManager.getUserInstance("Joe1");
        Assert.assertNull((Object)this.user.getId());
        this.userManager.addUser(this.user, "mc");
        this.user = this.userManager.getUserInstance("Joe2");
        Assert.assertNull((Object)this.user.getId());
        this.userManager.addUser(this.user, "mc");
        Assert.assertNotNull((Object)this.user.getId());
        Assert.assertNotNull((Object)this.userManager.getUser(this.user.getName()));
    }

    public void testAddUserTwiceFails() throws Exception {
        this.user = this.userManager.getUserInstance("EATLUNCH");
        this.userManager.addUser(this.user, "bob");
        Assert.assertTrue((boolean)this.userManager.checkExists(this.user.getName()));
        User user2 = this.userManager.getUserInstance("EATLUNCH");
        try {
            this.userManager.addUser(user2, "bob");
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
        try {
            this.userManager.addUser(user2, "differentpassword");
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }

    public void testCheckUserCaseSensitiveExists() throws Exception {
        this.user = this.userManager.getUserInstance("borrisJohnson");
        this.userManager.addUser(this.user, "bob");
        Assert.assertTrue((boolean)this.userManager.checkExists("borrisJohnson"));
    }
}

