/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine;

import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractTurbineModelManager
extends AbstractManager
implements TurbineModelManager {
    public Group getGlobalGroup() throws DataBackendException {
        Group g = null;
        try {
            g = this.getGroupManager().getGroupByName("global");
        }
        catch (UnknownEntityException uee) {
            g = this.getGroupManager().getGroupInstance("global");
            try {
                this.getGroupManager().addGroup(g);
            }
            catch (EntityExistsException eee) {
                throw new DataBackendException(eee.getMessage(), eee);
            }
        }
        return g;
    }

    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        roleExists = this.getRoleManager().checkExists(role);
        if (roleExists) {
            Object[] permissions = ((TurbineRole)role).getPermissions().toArray();
            int i = 0;
            while (i < permissions.length) {
                this.revoke(role, (Permission)permissions[i]);
                ++i;
            }
        } else {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.getUserManager().checkExists(user);
        if (userExists) {
            Object[] userGroupRoles = ((TurbineUser)user).getUserGroupRoleSet().toArray();
            int i = 0;
            while (i < userGroupRoles.length) {
                TurbineUserGroupRole ugr = (TurbineUserGroupRole)userGroupRoles[i];
                this.revoke(user, ugr.getGroup(), ugr.getRole());
                ++i;
            }
        } else {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }
}

