/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine.test;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.TurbineModelManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbineRole;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.testcontainer.BaseUnitTest;

public abstract class AbstractTurbineModelManagerTest
extends BaseUnitTest {
    protected Role role;
    protected TurbineModelManager modelManager;
    protected RoleManager roleManager;
    protected GroupManager groupManager;
    protected PermissionManager permissionManager;
    protected UserManager userManager;
    protected SecurityService securityService;

    public void setUp() throws Exception {
        super.setUp();
        this.roleManager = this.securityService.getRoleManager();
        this.userManager = this.securityService.getUserManager();
        this.groupManager = this.securityService.getGroupManager();
        this.permissionManager = this.securityService.getPermissionManager();
        this.modelManager = (TurbineModelManager)this.securityService.getModelManager();
    }

    public AbstractTurbineModelManagerTest(String arg0) {
        super(arg0);
    }

    public void testGetGlobalGroup() throws Exception {
        Group global = this.modelManager.getGlobalGroup();
        Assert.assertNotNull((Object)global);
        Assert.assertEquals((String)global.getName(), (String)"global");
    }

    public void testGrantRolePermission() throws Exception {
        Permission permission = this.permissionManager.getPermissionInstance();
        permission.setName("ANSWER_PHONE");
        this.permissionManager.addPermission(permission);
        this.role = this.roleManager.getRoleInstance("RECEPTIONIST");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assert.assertEquals((int)1, (int)permissions.size());
        Assert.assertTrue((boolean)((TurbineRole)this.role).getPermissions().contains(permission));
    }

    public void testRevokeRolePermission() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("ANSWER_FAX");
        this.securityService.getPermissionManager().addPermission(permission);
        this.role = this.roleManager.getRoleInstance("SECRETARY");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assert.assertEquals((int)1, (int)permissions.size());
        this.modelManager.revoke(this.role, permission);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((TurbineRole)this.role).getPermissions();
        Assert.assertEquals((int)0, (int)permissions.size());
        Assert.assertFalse((boolean)((TurbineRole)this.role).getPermissions().contains(permission));
    }

    public void testRevokeAllRole() throws Exception {
        Permission permission = this.securityService.getPermissionManager().getPermissionInstance();
        Permission permission2 = this.securityService.getPermissionManager().getPermissionInstance();
        permission.setName("SEND_SPAM");
        permission2.setName("ANSWER_EMAIL");
        this.securityService.getPermissionManager().addPermission(permission);
        this.securityService.getPermissionManager().addPermission(permission2);
        this.role = this.roleManager.getRoleInstance("HELPER");
        this.roleManager.addRole(this.role);
        this.modelManager.grant(this.role, permission);
        this.modelManager.grant(this.role, permission2);
        this.role = this.roleManager.getRoleById(this.role.getId());
        PermissionSet permissions = ((TurbineRole)this.role).getPermissions();
        Assert.assertEquals((int)2, (int)permissions.size());
        this.modelManager.revokeAll(this.role);
        this.role = this.roleManager.getRoleById(this.role.getId());
        permissions = ((TurbineRole)this.role).getPermissions();
        Assert.assertEquals((int)0, (int)permissions.size());
    }

    public void testRevokeAllUser() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKEALLUSER_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.securityService.getRoleManager().getRoleInstance();
        role.setName("TEST_REVOKEALLUSER_ROLE");
        this.securityService.getRoleManager().addRole(role);
        User user = this.userManager.getUserInstance("calvin");
        this.userManager.addUser(user, "calvin");
        this.modelManager.grant(user, group, role);
        group = this.groupManager.getGroupById(group.getId());
        Set userGroupRoleSet = ((TurbineGroup)group).getUserGroupRoleSet();
        Assert.assertEquals((int)1, (int)userGroupRoleSet.size());
        Set userGroupRoleSet2 = ((TurbineGroup)group).getUserGroupRoleSet();
        Assert.assertEquals((int)1, (int)userGroupRoleSet2.size());
        this.modelManager.revokeAll(user);
        Assert.assertEquals((int)0, (int)((TurbineGroup)group).getUserGroupRoleSet().size());
        role = this.securityService.getRoleManager().getRoleByName("TEST_REVOKEALLUSER_ROLE");
    }

    public void testGrantUserGroupRole() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_GROUP");
        this.securityService.getGroupManager().addGroup(group);
        Role role = this.roleManager.getRoleInstance();
        role.setName("TEST_Role");
        this.roleManager.addRole(role);
        User user = this.userManager.getUserInstance("Clint");
        this.userManager.addUser(user, "clint");
        this.modelManager.grant(user, group, role);
        boolean ugrFound = false;
        TurbineUserGroupRole ugr = null;
        Iterator i = ((TurbineUser)user).getUserGroupRoleSet().iterator();
        while (i.hasNext()) {
            ugr = (TurbineUserGroupRole)i.next();
            if (!ugr.getUser().equals(user) || !ugr.getGroup().equals(group) || !ugr.getRole().equals(role)) continue;
            ugrFound = true;
            break;
        }
        Assert.assertTrue((boolean)ugrFound);
        Assert.assertTrue((boolean)ugr.getGroup().equals(group));
        Assert.assertTrue((boolean)ugr.getUser().equals(user));
    }

    public void testRevokeUserGroupRole() throws Exception {
        Group group = this.securityService.getGroupManager().getGroupInstance();
        group.setName("TEST_REVOKE");
        this.securityService.getGroupManager().addGroup(group);
        User user = this.userManager.getUserInstance("Lima");
        this.userManager.addUser(user, "pet");
        Role role = this.roleManager.getRoleInstance();
        role.setName("TEST_REVOKE_ROLE");
        this.roleManager.addRole(role);
        this.modelManager.grant(user, group, role);
        this.modelManager.revoke(user, group, role);
        boolean ugrFound = false;
        TurbineUserGroupRole ugr = null;
        Iterator i = ((TurbineUser)user).getUserGroupRoleSet().iterator();
        while (i.hasNext()) {
            ugr = (TurbineUserGroupRole)i.next();
            if (!ugr.getUser().equals(user) || !ugr.getGroup().equals(group) || !ugr.getRole().equals(role)) continue;
            ugrFound = true;
            break;
        }
        Assert.assertFalse((boolean)ugrFound);
    }
}

