/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractGroupManager
extends AbstractEntityManager
implements GroupManager {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.spi.AbstractGroupManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected abstract Group persistNewGroup(Group var1) throws DataBackendException;

    public Group getGroupInstance() throws DataBackendException {
        Group group;
        try {
            group = (Group)Class.forName(this.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new DataBackendException("Problem creating instance of class " + this.getClassName(), e);
        }
        return group;
    }

    public Group getGroupInstance(String groupName) throws DataBackendException {
        Group group = this.getGroupInstance();
        group.setName(groupName);
        return group;
    }

    public Group getGroupByName(String name) throws DataBackendException, UnknownEntityException {
        Group group = this.getAllGroups().getGroupByName(name);
        if (group == null) {
            throw new UnknownEntityException("The specified group does not exist");
        }
        return group;
    }

    public Group getGroupById(Object id) throws DataBackendException, UnknownEntityException {
        Group group = this.getAllGroups().getGroupById(id);
        if (group == null) {
            throw new UnknownEntityException("The specified group does not exist");
        }
        return group;
    }

    public synchronized Group addGroup(Group group) throws DataBackendException, EntityExistsException {
        boolean groupExists = false;
        if (StringUtils.isEmpty((String)group.getName())) {
            throw new DataBackendException("Could not create a group with empty name!");
        }
        if (group.getId() != null) {
            throw new DataBackendException("Could not create a group with an id!");
        }
        groupExists = this.checkExists(group);
        if (!groupExists) {
            return this.persistNewGroup(group);
        }
        throw new EntityExistsException("Group '" + group + "' already exists");
    }

    public boolean checkExists(Group group) throws DataBackendException {
        return this.checkExists(group.getName());
    }
}

