/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.util.DataBackendException;

public abstract class AbstractManager
extends AbstractLogEnabled
implements Serviceable,
Disposable,
ThreadSafe {
    boolean composed = false;
    private static Log log;
    private ServiceManager manager = null;
    private PermissionManager permissionManager;
    private RoleManager roleManager;
    private GroupManager groupManager;
    private UserManager userManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.spi.AbstractManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected ServiceManager getServiceManager() {
        return this.manager;
    }

    protected UserManager getUserManager() throws DataBackendException {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)this.manager.lookup(UserManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new DataBackendException(ce.getMessage(), ce);
            }
        }
        return this.userManager;
    }

    protected PermissionManager getPermissionManager() throws DataBackendException {
        if (this.permissionManager == null) {
            try {
                this.permissionManager = (PermissionManager)this.manager.lookup(PermissionManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new DataBackendException(ce.getMessage(), ce);
            }
        }
        return this.permissionManager;
    }

    protected RoleManager getRoleManager() throws DataBackendException {
        if (this.roleManager == null) {
            try {
                this.roleManager = (RoleManager)this.manager.lookup(RoleManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new DataBackendException(ce.getMessage(), ce);
            }
        }
        return this.roleManager;
    }

    protected GroupManager getGroupManager() throws DataBackendException {
        if (this.groupManager == null) {
            try {
                this.groupManager = (GroupManager)this.manager.lookup(GroupManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new DataBackendException(ce.getMessage(), ce);
            }
        }
        return this.groupManager;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        this.release(this.roleManager);
        this.release(this.permissionManager);
        this.release(this.groupManager);
        this.release(this.userManager);
        this.manager = null;
    }

    protected void release(Object obj) {
        if (obj != null) {
            this.manager.release(obj);
            obj = null;
        }
    }

    protected Object resolve(String lookup) {
        Object component = null;
        try {
            component = this.manager.lookup(lookup);
        }
        catch (ServiceException ce) {
            throw new RuntimeException(ce.getMessage(), ce);
        }
        return component;
    }
}

