/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractPermissionManager
extends AbstractEntityManager
implements PermissionManager {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.spi.AbstractPermissionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected abstract Permission persistNewPermission(Permission var1) throws DataBackendException;

    public Permission getPermissionInstance() throws UnknownEntityException {
        Permission permission;
        try {
            permission = (Permission)Class.forName(this.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Permission implementation object", e);
        }
        return permission;
    }

    public Permission getPermissionInstance(String permName) throws UnknownEntityException {
        Permission perm = this.getPermissionInstance();
        perm.setName(permName);
        return perm;
    }

    public Permission getPermissionByName(String name) throws DataBackendException, UnknownEntityException {
        Permission permission = this.getAllPermissions().getPermissionByName(name);
        if (permission == null) {
            throw new UnknownEntityException("The specified permission does not exist");
        }
        return permission;
    }

    public Permission getPermissionById(Object id) throws DataBackendException, UnknownEntityException {
        Permission permission = this.getAllPermissions().getPermissionById(id);
        if (permission == null) {
            throw new UnknownEntityException("The specified permission does not exist");
        }
        return permission;
    }

    public synchronized Permission addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        boolean permissionExists = false;
        if (StringUtils.isEmpty((String)permission.getName())) {
            throw new DataBackendException("Could not create a permission with empty name!");
        }
        if (permission.getId() != null) {
            throw new DataBackendException("Could not create a permission with an id!");
        }
        try {
            permissionExists = this.checkExists(permission);
            if (!permissionExists) {
                return this.persistNewPermission(permission);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addPermission(Permission) failed", e);
        }
        throw new EntityExistsException("Permission '" + permission + "' already exists");
    }

    public boolean checkExists(Permission permission) throws DataBackendException {
        return this.checkExists(permission.getName());
    }
}

