/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractRoleManager
extends AbstractEntityManager
implements RoleManager {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.spi.AbstractRoleManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected abstract Role persistNewRole(Role var1) throws DataBackendException;

    public Role getRoleInstance() throws DataBackendException {
        Role role;
        try {
            role = (Role)Class.forName(this.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new DataBackendException("Problem creating instance of class " + this.getClassName(), e);
        }
        return role;
    }

    public Role getRoleInstance(String roleName) throws DataBackendException {
        Role role = this.getRoleInstance();
        role.setName(roleName);
        return role;
    }

    public Role getRoleByName(String name) throws DataBackendException, UnknownEntityException {
        Role role = this.getAllRoles().getRoleByName(name);
        if (role == null) {
            throw new UnknownEntityException("The specified role does not exist");
        }
        return role;
    }

    public Role getRoleById(Object id) throws DataBackendException, UnknownEntityException {
        Role role = this.getAllRoles().getRoleById(id);
        if (role == null) {
            throw new UnknownEntityException("The specified role does not exist");
        }
        return role;
    }

    public synchronized Role addRole(Role role) throws DataBackendException, EntityExistsException {
        boolean roleExists = false;
        if (StringUtils.isEmpty((String)role.getName())) {
            throw new DataBackendException("Could not create a role with empty name!");
        }
        if (role.getId() != null) {
            throw new DataBackendException("Could not create a role with an id!");
        }
        try {
            roleExists = this.checkExists(role);
            if (!roleExists) {
                return this.persistNewRole(role);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addRole(Role) failed", e);
        }
        throw new EntityExistsException("Role '" + role + "' already exists");
    }

    public boolean checkExists(Role role) throws DataBackendException {
        return this.checkExists(role.getName());
    }
}

