/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.authenticator.Authenticator;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractUserManager
extends AbstractEntityManager
implements UserManager {
    private static Log log;
    private ACLFactory aclFactory;
    private Authenticator authenticator;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.spi.AbstractUserManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected abstract User persistNewUser(User var1) throws DataBackendException;

    public AccessControlList getACL(User user) throws UnknownEntityException {
        return this.getACLFactory().getAccessControlList(user);
    }

    public boolean checkExists(User user) throws DataBackendException {
        return this.checkExists(user.getName());
    }

    public User getUser(String userName, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.getUser(userName);
        this.authenticate(user, password);
        return user;
    }

    public User getUser(String name) throws DataBackendException, UnknownEntityException {
        User user = this.getAllUsers().getUserByName(name);
        if (user == null) {
            throw new UnknownEntityException("The specified user does not exist");
        }
        return user;
    }

    public User getUserById(Object id) throws DataBackendException, UnknownEntityException {
        User user = this.getAllUsers().getUserById(id);
        if (user == null) {
            throw new UnknownEntityException("The specified user does not exist");
        }
        return user;
    }

    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (this.authenticator == null) {
            this.authenticator = (Authenticator)this.resolve(Authenticator.ROLE);
        }
        if (!this.authenticator.authenticate(user, password)) {
            throw new PasswordMismatchException("Can not authenticate user.");
        }
    }

    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.checkExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        if (!oldPassword.equals(user.getPassword())) {
            throw new PasswordMismatchException("The supplied old password for '" + user.getName() + "' was incorrect");
        }
        user.setPassword(newPassword);
        this.saveUser(user);
    }

    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        if (!this.checkExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        user.setPassword(password);
        this.saveUser(user);
    }

    public User getUserInstance() throws DataBackendException {
        User user;
        try {
            user = (User)Class.forName(this.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new DataBackendException("Problem creating instance of class " + this.getClassName(), e);
        }
        return user;
    }

    public User getUserInstance(String userName) throws DataBackendException {
        User user = this.getUserInstance();
        user.setName(userName);
        return user;
    }

    public User addUser(User user, String password) throws DataBackendException, EntityExistsException {
        if (StringUtils.isEmpty((String)user.getName())) {
            throw new DataBackendException("Could not create an user with empty name!");
        }
        if (this.checkExists(user)) {
            throw new EntityExistsException("The account '" + user.getName() + "' already exists");
        }
        user.setPassword(password);
        try {
            return this.persistNewUser(user);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to create account '" + user.getName() + "'", e);
        }
    }

    public ACLFactory getACLFactory() {
        if (this.aclFactory == null) {
            this.aclFactory = (ACLFactory)this.resolve(ACLFactory.ROLE);
        }
        return this.aclFactory;
    }
}

