/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.util.SecuritySet;

public class GroupSet
extends SecuritySet {
    public GroupSet() {
    }

    public GroupSet(Collection groups) {
        this.add(groups);
    }

    public boolean add(Group group) {
        if (this.contains(group)) {
            return false;
        }
        this.idMap.put(group.getId(), group);
        return true;
    }

    public boolean add(Object obj) {
        if (obj instanceof Group) {
            return this.add((Group)obj);
        }
        throw new ClassCastException("Object passed to add to GroupSet is not of type Group");
    }

    public boolean add(Collection groups) {
        boolean res = false;
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            res |= this.add(g);
        }
        return res;
    }

    public boolean add(GroupSet groupSet) {
        boolean res = false;
        Iterator it = groupSet.iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            res |= this.add(g);
        }
        return res;
    }

    public boolean remove(Group group) {
        boolean res = this.contains(group);
        this.idMap.remove(group.getId());
        return res;
    }

    public boolean contains(Group group) {
        return super.contains(group);
    }

    public Group getGroupByName(String groupName) {
        return (Group)this.getByName(groupName);
    }

    public Group getGroupById(Object groupId) {
        return groupId != null ? (Group)this.idMap.get(groupId) : null;
    }

    public Group[] getGroupsArray() {
        return this.getSet().toArray(new Group[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GroupSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Group g = (Group)it.next();
            sb.append('[');
            sb.append(g.getName());
            sb.append(" -> ");
            sb.append(g.getId());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

