/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.util.SecuritySet;

public class PermissionSet
extends SecuritySet {
    public PermissionSet() {
    }

    public PermissionSet(Collection permissions) {
        this.add(permissions);
    }

    public boolean add(Permission permission) {
        if (this.contains(permission)) {
            return false;
        }
        this.idMap.put(permission.getId(), permission);
        return true;
    }

    public boolean add(Object obj) {
        if (obj instanceof Permission) {
            return this.add((Permission)obj);
        }
        throw new ClassCastException("Object passed to add to PermissionSet is not of type Permission");
    }

    public boolean add(Collection permissions) {
        boolean res = false;
        Iterator it = permissions.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            res |= this.add(p);
        }
        return res;
    }

    public boolean add(PermissionSet permissionSet) {
        boolean res = false;
        Iterator it = permissionSet.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            res |= this.add(p);
        }
        return res;
    }

    public boolean remove(Permission permission) {
        boolean res = this.contains(permission);
        this.idMap.remove(permission.getId());
        return res;
    }

    public boolean contains(Permission permission) {
        return super.contains(permission);
    }

    public Permission getPermissionByName(String permissionName) {
        return (Permission)this.getByName(permissionName);
    }

    public Permission getPermissionById(Object permissionId) {
        return permissionId != null ? (Permission)this.idMap.get(permissionId) : null;
    }

    public Permission[] getPermissionsArray() {
        return this.getSet().toArray(new Permission[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PermissionSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            sb.append('[');
            sb.append(p.getName());
            sb.append(" -> ");
            sb.append(p.getId());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

