/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.util.SecuritySet;

public class RoleSet
extends SecuritySet {
    public RoleSet() {
    }

    public RoleSet(Collection roles) {
        this.add(roles);
    }

    public boolean add(Role role) {
        if (this.contains(role)) {
            return false;
        }
        this.idMap.put(role.getId(), role);
        return true;
    }

    public boolean add(Object obj) {
        if (obj instanceof Role) {
            return this.add((Role)obj);
        }
        throw new ClassCastException("Object passed to add to RoleSet is not of type Role");
    }

    public boolean add(Collection roles) {
        boolean res = false;
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            res |= this.add(r);
        }
        return res;
    }

    public boolean add(RoleSet roleSet) {
        boolean res = false;
        Iterator it = roleSet.iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            res |= this.add(r);
        }
        return res;
    }

    public boolean remove(Role role) {
        boolean res = this.contains(role);
        this.idMap.remove(role.getId());
        return res;
    }

    public boolean contains(Role role) {
        return super.contains(role);
    }

    public Role getRoleByName(String roleName) {
        return (Role)this.getByName(roleName);
    }

    public Role getRoleById(Object roleId) {
        return roleId != null ? (Role)this.idMap.get(roleId) : null;
    }

    public Role[] getRolesArray() {
        return this.getSet().toArray(new Role[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RoleSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            sb.append('[');
            sb.append(r.getName());
            sb.append(" -> ");
            sb.append(r.getId());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

