/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.security.entity.SecurityEntity;

public abstract class SecuritySet
implements Serializable,
Set {
    protected Map idMap = new TreeMap();

    public abstract boolean add(Object var1);

    public Set getSet() {
        return new HashSet(this.idMap.values());
    }

    public Set getNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator i = this.getSet().iterator();
        while (i.hasNext()) {
            SecurityEntity se = (SecurityEntity)i.next();
            names.add(se.getName());
        }
        return names;
    }

    public Set getIds() {
        return this.idMap.keySet();
    }

    public void clear() {
        this.idMap.clear();
    }

    public boolean containsName(String name) {
        return StringUtils.isNotEmpty((String)name) ? this.getNames().contains(name.toLowerCase()) : false;
    }

    public boolean containsId(Object id) {
        return id == null ? false : this.idMap.containsKey(id);
    }

    public Iterator iterator() {
        return this.idMap.values().iterator();
    }

    public int size() {
        return this.idMap.size();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(12 * this.size());
        Iterator it = this.idMap.keySet().iterator();
        while (it.hasNext()) {
            sbuf.append((String)it.next());
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    public boolean addAll(Collection collection) {
        return this.add(collection);
    }

    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }

    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean changed = false;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            boolean result = this.remove(object);
            if (!result) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    public Object[] toArray() {
        return this.getSet().toArray();
    }

    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.containsName(((SecurityEntity)o).getName());
    }

    public boolean remove(Object o) {
        SecurityEntity se = (SecurityEntity)o;
        boolean res = this.contains(se);
        this.idMap.remove(se.getId());
        return res;
    }

    public Object[] toArray(Object[] a) {
        return this.getSet().toArray(a);
    }

    public SecurityEntity getByName(String name) {
        SecurityEntity securityEntity = null;
        Iterator i = this.getSet().iterator();
        while (i.hasNext()) {
            SecurityEntity se = (SecurityEntity)i.next();
            if (!se.getName().equalsIgnoreCase(name)) continue;
            securityEntity = se;
            break;
        }
        return securityEntity;
    }
}

