/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.SecuritySet;

public class UserSet
extends SecuritySet {
    public UserSet() {
    }

    public UserSet(Collection users) {
        this.add(users);
    }

    public boolean add(User user) {
        if (this.contains(user)) {
            return false;
        }
        this.idMap.put(user.getId(), user);
        return true;
    }

    public boolean add(Object obj) {
        if (obj instanceof User) {
            return this.add((User)obj);
        }
        throw new ClassCastException("Object passed to add to UserSet is not of type User");
    }

    public boolean add(Collection users) {
        boolean res = false;
        Iterator it = users.iterator();
        while (it.hasNext()) {
            User r = (User)it.next();
            res |= this.add(r);
        }
        return res;
    }

    public boolean add(UserSet userSet) {
        boolean res = false;
        Iterator it = userSet.iterator();
        while (it.hasNext()) {
            User r = (User)it.next();
            res |= this.add(r);
        }
        return res;
    }

    public boolean remove(User user) {
        boolean res = this.contains(user);
        this.idMap.remove(user.getId());
        return res;
    }

    public boolean contains(User user) {
        return super.contains(user);
    }

    public User getUserByName(String userName) {
        return (User)this.getByName(userName);
    }

    public User getUserById(Object userId) {
        return userId != null ? (User)this.idMap.get(userId) : null;
    }

    public User[] getUsersArray() {
        return this.getSet().toArray(new User[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("UserSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            User r = (User)it.next();
            sb.append('[');
            sb.append(r.getName());
            sb.append(" -> ");
            sb.append(r.getId());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

