/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.hibernate;

import java.util.Collection;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.hibernate.PersistenceHelper;
import org.apache.fulcrum.security.spi.AbstractRoleManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class HibernateRoleManagerImpl
extends AbstractRoleManager {
    private static Log log;
    private PersistenceHelper persistenceHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.hibernate.HibernateRoleManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        roleExists = this.checkExists(role);
        if (roleExists) {
            role.setName(name);
            this.getPersistenceHelper().updateEntity((SecurityEntity)role);
            return;
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public boolean checkExists(String roleName) throws DataBackendException {
        List roles;
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Role");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            roles = session.find(stringBuffer.append(clazz.getName()).append(" sr where sr.name=?").toString(), (Object)roleName, (Type)Hibernate.STRING);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving role information", (Throwable)e);
        }
        if (roles.size() > 1) {
            throw new DataBackendException("Multiple roles with same name '" + roleName + "'");
        }
        return roles.size() == 1;
    }

    public RoleSet getAllRoles() throws DataBackendException {
        RoleSet roleSet = new RoleSet();
        try {
            Session session = this.getPersistenceHelper().retrieveSession();
            StringBuffer stringBuffer = new StringBuffer("from ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Role");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            List roles = session.find(stringBuffer.append(clazz.getName()).toString());
            roleSet.add((Collection)roles);
        }
        catch (HibernateException e) {
            throw new DataBackendException("Error retriving role information", (Throwable)e);
        }
        return roleSet;
    }

    protected synchronized Role persistNewRole(Role role) throws DataBackendException {
        this.getPersistenceHelper().addEntity((SecurityEntity)role);
        return role;
    }

    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (!roleExists) {
                throw new UnknownEntityException("Unknown role '" + role + "'");
            }
            this.getPersistenceHelper().removeEntity((SecurityEntity)role);
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete a Role");
            log.error((Object)e);
            throw new DataBackendException("removeRole(Role) failed", (Throwable)e);
        }
    }

    public PersistenceHelper getPersistenceHelper() throws DataBackendException {
        if (this.persistenceHelper == null) {
            this.persistenceHelper = (PersistenceHelper)this.resolve(PersistenceHelper.ROLE);
        }
        return this.persistenceHelper;
    }

    public Role getRoleById(Object id) throws DataBackendException, UnknownEntityException {
        Role role = null;
        if (id != null) {
            try {
                List roles;
                Session session = this.getPersistenceHelper().retrieveSession();
                StringBuffer stringBuffer = new StringBuffer("from ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.apache.fulcrum.security.entity.Role");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((roles = session.find(stringBuffer.append(clazz.getName()).append(" sr where sr.id=?").toString(), id, (Type)Hibernate.LONG)).size() == 0) {
                    throw new UnknownEntityException("Could not find role by id " + id);
                }
                role = (Role)roles.get(0);
            }
            catch (HibernateException e) {
                throw new DataBackendException("Error retriving role information", (Throwable)e);
            }
        }
        return role;
    }
}

