/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.hibernate.basic;

import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.hibernate.PersistenceHelper;
import org.apache.fulcrum.security.model.basic.BasicModelManager;
import org.apache.fulcrum.security.model.basic.entity.BasicGroup;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class HibernateModelManagerImpl
extends AbstractManager
implements BasicModelManager {
    private static Log log;
    private PersistenceHelper persistenceHelper;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.hibernate.basic.HibernateModelManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public synchronized void grant(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean userExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            userExists = this.getUserManager().checkExists(user);
            if (groupExists && userExists) {
                Session session = this.getPersistenceHelper().retrieveSession();
                Transaction transaction = session.beginTransaction();
                ((BasicUser)user).addGroup(group);
                ((BasicGroup)group).addUser(user);
                session.update((Object)user);
                session.update((Object)group);
                transaction.commit();
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void revoke(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean userExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            userExists = this.getUserManager().checkExists(user);
            if (groupExists && userExists) {
                Session session = this.getPersistenceHelper().retrieveSession();
                Transaction transaction = session.beginTransaction();
                ((BasicUser)user).removeGroup(group);
                ((BasicGroup)group).removeUser(user);
                session.update((Object)user);
                session.update((Object)group);
                transaction.commit();
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        userExists = this.getUserManager().checkExists(user);
        if (userExists) {
            Object[] groups = ((BasicUser)user).getGroups().toArray();
            int i = 0;
            while (i < groups.length) {
                Group group = (Group)groups[i];
                this.revoke(user, group);
                ++i;
            }
            return;
        }
        throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
    }

    public PersistenceHelper getPersistenceHelper() throws DataBackendException {
        if (this.persistenceHelper == null) {
            this.persistenceHelper = (PersistenceHelper)this.resolve(PersistenceHelper.ROLE);
        }
        return this.persistenceHelper;
    }
}

