/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.authenticator;

import com.tagish.auth.win32.NTSystem;
import javax.security.auth.login.LoginException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.authenticator.Authenticator;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.nt.ParseUtils;
import org.apache.fulcrum.security.util.DataBackendException;

public class NTAuthenticator
extends AbstractLogEnabled
implements Authenticator {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.authenticator.NTAuthenticator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean authenticate(User user, String password) throws DataBackendException {
        boolean authenticated = false;
        NTSystem ntSystem = new NTSystem();
        char[] passwordArray = password.toCharArray();
        try {
            String username = ParseUtils.parseForUsername(user.getName());
            String domain = ParseUtils.parseForDomain(user.getName());
            ntSystem.logon(username, passwordArray, domain);
            if (ntSystem.getName().equalsIgnoreCase(username)) {
                authenticated = true;
            }
            ntSystem.logoff();
        }
        catch (LoginException le) {
            ntSystem.logoff();
            throw new DataBackendException(le.getMessage(), (Throwable)le);
        }
        return authenticated;
    }
}

