/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.nt;

import com.tagish.auth.win32.NTSystem;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.nt.ParseUtils;
import org.apache.fulcrum.security.spi.AbstractUserManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;

public class NTUserManagerImpl
extends AbstractUserManager {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.fulcrum.security.nt.NTUserManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected User persistNewUser(User user) throws DataBackendException {
        throw new RuntimeException("This method is not supported.");
    }

    public User getUser(String userName, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.getUserInstance(userName);
        this.authenticate(user, password);
        return user;
    }

    public boolean checkExists(User user) throws DataBackendException {
        boolean exists = false;
        try {
            this.authenticate(user, user.getPassword());
            exists = true;
        }
        catch (PasswordMismatchException pme) {
            exists = false;
        }
        catch (UnknownEntityException uee) {
            exists = false;
        }
        return exists;
    }

    public boolean checkExists(String userName) throws DataBackendException {
        throw new RuntimeException("This method is not supported.");
    }

    public User getUser(String userName) throws UnknownEntityException, DataBackendException {
        throw new RuntimeException("Not supported by NT User Manager");
    }

    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        NTSystem ntSystem = new NTSystem();
        char[] passwordArray = password.toCharArray();
        try {
            String username = ParseUtils.parseForUsername(user.getName());
            String domain = ParseUtils.parseForDomain(user.getName());
            ntSystem.logon(username, passwordArray, domain);
            if (!ntSystem.getName().equalsIgnoreCase(username)) {
                throw new PasswordMismatchException("Could not authenticate user " + username + " against domain " + domain);
            }
            String[] groups = ntSystem.getGroupNames(false);
            int i = 0;
            while (i < groups.length) {
                Group group = this.getGroupManager().getGroupInstance();
                group.setName(groups[i]);
                group.setId((Object)groups[i]);
                if (user instanceof DynamicUser) {
                    ((DynamicUser)user).addGroup(group);
                } else if (user instanceof BasicUser) {
                    ((BasicUser)user).addGroup(group);
                }
                ++i;
            }
            ntSystem.logoff();
        }
        catch (LoginException le) {
            ntSystem.logoff();
            throw new DataBackendException(le.getMessage(), (Throwable)le);
        }
    }

    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        throw new RuntimeException("Not supported by NT User Manager");
    }

    public User addUser(User user, String password) throws DataBackendException, EntityExistsException {
        throw new RuntimeException("Not supported by NT User Manager");
    }

    public void saveUser(User user) throws DataBackendException, UnknownEntityException {
        throw new RuntimeException("Not supported by NT User Manager");
    }

    public UserSet getAllUsers() throws DataBackendException {
        throw new RuntimeException("Not supported by NT User Manager");
    }
}

