/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.testcontainer;

import java.io.File;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.testcontainer.Container;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainerImpl;
import org.apache.fulcrum.yaafi.framework.factory.ServiceManagerFactory;
import org.apache.fulcrum.yaafi.service.servicemanager.ServiceManagerService;

public class YAAFIContainer
extends AbstractLogEnabled
implements Container {
    private ServiceContainer manager = new ServiceContainerImpl();
    private String configFileName;
    private String roleFileName;
    private String parametersFileName;

    public YAAFIContainer() {
        this.enableLogging((Logger)new ConsoleLogger(0));
    }

    public void startup(String configFileName, String roleFileName, String parametersFileName) {
        this.getLogger().debug("Starting container...");
        this.configFileName = configFileName;
        this.roleFileName = roleFileName;
        this.parametersFileName = parametersFileName;
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            throw new RuntimeException("Could not initialize the container because the config file could not be found:" + configFile);
        }
        try {
            this.initialize();
            this.getLogger().info("YaffiContainer ready.");
        }
        catch (Exception e) {
            this.getLogger().error("Could not initialize the container", (Throwable)e);
            throw new RuntimeException("Could not initialize the container");
        }
    }

    public void initialize() throws Exception {
        DefaultContext context = new DefaultContext();
        String absolutePath = new File("").getAbsolutePath();
        context.put((Object)"componentAppRoot", (Object)absolutePath);
        context.put((Object)"urn:avalon:home", (Object)new File(new File("").getAbsolutePath()));
        ConsoleLogger logger = new ConsoleLogger(0);
        this.manager = ServiceManagerFactory.create((Logger)logger, (String)this.roleFileName, (String)this.configFileName, (String)this.parametersFileName, (Context)context);
    }

    public void dispose() {
        this.getLogger().debug("Disposing of container...");
        this.manager.dispose();
        this.getLogger().info("YaffiContainer has been disposed.");
    }

    public Object lookup(String roleName) throws ComponentException {
        try {
            return this.manager.lookup(roleName);
        }
        catch (Exception e) {
            String msg = "Failed to lookup role " + roleName;
            throw new ComponentException(roleName, msg, (Throwable)e);
        }
    }

    public void release(Component component) {
        ServiceManagerService.getServiceManager().release((Object)component);
    }

    public void release(Object component) {
        this.manager.release(component);
    }
}

