/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.testcontainer;

import junit.framework.TestCase;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.fulcrum.testcontainer.Container;
import org.apache.fulcrum.testcontainer.ECMContainer;
import org.apache.fulcrum.testcontainer.YAAFIContainer;

public class BaseUnitTest
extends TestCase {
    public static final String CONTAINER_ECM = "CONTAINER_ECM";
    public static final String CONTAINER_YAAFI = "CONTAINER_YAAFI";
    public static String COMPONENT_APP_ROOT = "componentAppRoot";
    public static String containerType = "CONTAINER_YAAFI";
    private Container container;
    private String configurationFileName = "src/test/TestComponentConfig.xml";
    private String roleFileName = "src/test/TestRoleConfig.xml";
    private String parameterFileName = null;

    protected void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    protected void setRoleFileName(String roleFileName) {
        this.roleFileName = roleFileName;
    }

    public BaseUnitTest(String testName) {
        super(testName);
    }

    protected void tearDown() {
        if (this.container != null) {
            this.container.dispose();
        }
        this.container = null;
    }

    protected String getConfigurationFileName() {
        return this.configurationFileName;
    }

    protected String getRoleFileName() {
        return this.roleFileName;
    }

    protected String getParameterFileName() {
        return this.parameterFileName;
    }

    protected Object lookup(String roleName) throws ComponentException {
        if (this.container == null) {
            this.container = containerType.equals(CONTAINER_ECM) ? new ECMContainer() : new YAAFIContainer();
            this.container.startup(this.getConfigurationFileName(), this.getRoleFileName(), this.getParameterFileName());
        }
        return this.container.lookup(roleName);
    }

    protected Object resolve(String roleName) throws ComponentException {
        return this.lookup(roleName);
    }

    protected void release(Object component) {
        if (this.container != null) {
            this.container.release(component);
        }
    }
}

