/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.FruitfulComparator;
import gov.nih.nlm.nls.lvg.Db.FruitfulRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbFruitful {
    public static Vector<FruitfulRecord> GetFruitfulVariants(String inStr, Connection conn) throws SQLException {
        String query = "SELECT termLc, variantTerm, termCat, termInfl, orgCat, orgInfl, flowHistory, dist, tagInfo FROM Fruitful WHERE termLc = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        Vector<FruitfulRecord> fruitfuls = new Vector<FruitfulRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            FruitfulRecord fruitfulRecord = new FruitfulRecord();
            fruitfulRecord.SetLowerCasedTerm(rs.getString(1));
            fruitfulRecord.SetVariantTerm(rs.getString(2));
            fruitfulRecord.SetCategory(rs.getInt(3));
            fruitfulRecord.SetInflection(rs.getLong(4));
            fruitfulRecord.SetOriginalCategory(rs.getInt(5));
            fruitfulRecord.SetOriginalInflection(rs.getLong(6));
            fruitfulRecord.SetFlowHistory(rs.getString(7));
            fruitfulRecord.SetDistance(rs.getInt(8));
            fruitfulRecord.SetTagInformation(rs.getLong(9));
            fruitfuls.addElement(fruitfulRecord);
        }
        rs.close();
        ps.close();
        FruitfulComparator fc = new FruitfulComparator();
        Collections.sort(fruitfuls, fc);
        return fruitfuls;
    }

    public static void main(String[] args) {
        String testStr = "neurological";
        if (args.length == 1) {
            testStr = args[0];
        }
        System.out.println("--- TestStr:  " + testStr);
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<FruitfulRecord> fruitfulList = DbFruitful.GetFruitfulVariants(testStr, conn);
                System.out.println("----- Total Fruitful Variants found: " + fruitfulList.size());
                for (int j = 0; j < fruitfulList.size(); ++j) {
                    FruitfulRecord rec = fruitfulList.elementAt(j);
                    System.out.println("=== Found Fruitfuls ===");
                    System.out.println(rec.GetVariantTerm() + "|" + rec.GetCategory() + "|" + rec.GetInflection() + "|" + rec.GetOriginalCategory() + "|" + rec.GetOriginalInflection() + "|" + rec.GetFlowHistory() + "|" + rec.GetDistance() + "|" + rec.GetTagInformation());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

