/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.SynonymComparator;
import gov.nih.nlm.nls.lvg.Db.SynonymRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbSynonym {
    public static Vector<SynonymRecord> GetSynonyms(String inStr, Connection conn) throws SQLException {
        String query = "SELECT keyFormNpLc, keyForm, aSynonym, cat1, cat2 FROM LexSynonym WHERE keyFormNpLc = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        Vector<SynonymRecord> synonyms = new Vector<SynonymRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            SynonymRecord synonymRecord = new SynonymRecord();
            synonymRecord.SetKeyFormNpLc(rs.getString(1));
            synonymRecord.SetKeyForm(rs.getString(2));
            synonymRecord.SetSynonym(rs.getString(3));
            synonymRecord.SetCat1(rs.getInt(4));
            synonymRecord.SetCat2(rs.getInt(5));
            synonyms.addElement(synonymRecord);
        }
        rs.close();
        ps.close();
        SynonymComparator sc = new SynonymComparator();
        Collections.sort(synonyms, sc);
        return synonyms;
    }

    public static void main(String[] args) {
        String testStr = "aminophylline";
        if (args.length == 1) {
            testStr = args[0];
        }
        System.out.println("--- TestStr:  " + testStr);
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<SynonymRecord> synonymList = DbSynonym.GetSynonyms(testStr, conn);
                System.out.println("----- Total Synonyms found: " + synonymList.size());
                for (int j = 0; j < synonymList.size(); ++j) {
                    SynonymRecord rec = synonymList.elementAt(j);
                    System.out.println("=== Found Synonyms ===");
                    System.out.println(rec.GetKeyFormNpLc() + "|" + rec.GetKeyForm() + "|" + rec.GetCat1() + "|" + rec.GetSynonym() + "|" + rec.GetCat2());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

